/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.performance.categorization;

import gov.sandia.cognition.learning.performance.categorization.ConfusionMatrix;
import gov.sandia.cognition.util.AbstractCloneableSerializable;

public abstract class AbstractConfusionMatrix<CategoryType>
extends AbstractCloneableSerializable
implements ConfusionMatrix<CategoryType> {
    @Override
    public void add(CategoryType target, CategoryType estimate) {
        this.add(target, estimate, 1.0);
    }

    @Override
    public <OtherType extends CategoryType> void addAll(ConfusionMatrix<OtherType> other) {
        for (OtherType target : other.getActualCategories()) {
            for (OtherType estimate : other.getPredictedCategories(target)) {
                this.add(target, estimate, other.getCount(target, estimate));
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getTotalCount() <= 0.0;
    }

    @Override
    public double getTotalCount() {
        double result = 0.0;
        for (Object target : this.getActualCategories()) {
            result += this.getActualCount(target);
        }
        return result;
    }

    @Override
    public double getTotalCorrectCount() {
        double correct = 0.0;
        for (Object category : this.getActualCategories()) {
            correct += this.getCount(category, category);
        }
        return correct;
    }

    @Override
    public double getTotalIncorrectCount() {
        return this.getTotalCount() - this.getTotalCorrectCount();
    }

    @Override
    public double getActualCount(CategoryType target) {
        double result = 0.0;
        for (Object estimate : this.getPredictedCategories(target)) {
            result += this.getCount(target, estimate);
        }
        return result;
    }

    @Override
    public double getPredictedCount(CategoryType predicted) {
        double result = 0.0;
        for (Object actual : this.getActualCategories()) {
            result += this.getCount(actual, predicted);
        }
        return result;
    }

    @Override
    public double getAccuracy() {
        return this.getTotalCorrectCount() / this.getTotalCount();
    }

    @Override
    public double getCategoryAccuracy(CategoryType category) {
        return this.getCount(category, category) / this.getActualCount(category);
    }

    @Override
    public double getAverageCategoryAccuracy() {
        double sum = 0.0;
        int categoryCount = 0;
        for (Object actual : this.getActualCategories()) {
            if (!(this.getActualCount(actual) > 0.0)) continue;
            sum += this.getCategoryAccuracy(actual);
            ++categoryCount;
        }
        return sum / (double)categoryCount;
    }

    @Override
    public double getErrorRate() {
        return 1.0 - this.getAccuracy();
    }

    @Override
    public double getCategoryErrorRate(CategoryType category) {
        return 1.0 - this.getCategoryAccuracy(category);
    }

    @Override
    public double getAverageCategoryErrorRate() {
        double sum = 0.0;
        int categoryCount = 0;
        for (Object actual : this.getActualCategories()) {
            if (!(this.getActualCount(actual) > 0.0)) continue;
            sum += this.getCategoryErrorRate(actual);
            ++categoryCount;
        }
        return sum / (double)categoryCount;
    }
}

