/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.performance.categorization;

import gov.sandia.cognition.learning.function.categorization.AbstractBinaryCategorizer;
import gov.sandia.cognition.learning.performance.categorization.AbstractConfusionMatrix;
import gov.sandia.cognition.learning.performance.categorization.BinaryConfusionMatrix;
import gov.sandia.cognition.util.ArgumentChecker;
import java.util.Set;

public abstract class AbstractBinaryConfusionMatrix
extends AbstractConfusionMatrix<Boolean>
implements BinaryConfusionMatrix {
    @Override
    public Set<Boolean> getCategories() {
        return AbstractBinaryCategorizer.BINARY_CATEGORIES;
    }

    @Override
    public Set<Boolean> getActualCategories() {
        return AbstractBinaryCategorizer.BINARY_CATEGORIES;
    }

    @Override
    public Set<Boolean> getPredictedCategories() {
        return AbstractBinaryCategorizer.BINARY_CATEGORIES;
    }

    @Override
    public Set<Boolean> getPredictedCategories(Boolean target) {
        return AbstractBinaryCategorizer.BINARY_CATEGORIES;
    }

    @Override
    public double getCount(Boolean target, Boolean estimate) {
        if (target.booleanValue()) {
            if (estimate.booleanValue()) {
                return this.getTruePositivesCount();
            }
            return this.getFalseNegativesCount();
        }
        if (estimate.booleanValue()) {
            return this.getFalsePositivesCount();
        }
        return this.getTrueNegativesCount();
    }

    @Override
    public double getActualCount(Boolean target) {
        if (target.booleanValue()) {
            return this.getTruePositivesCount() + this.getFalseNegativesCount();
        }
        return this.getFalsePositivesCount() + this.getTrueNegativesCount();
    }

    @Override
    public double getTruePositivesFraction() {
        return this.getTruePositivesCount() / this.getTotalCount();
    }

    @Override
    public double getFalsePositivesFraction() {
        return this.getFalsePositivesCount() / this.getTotalCount();
    }

    @Override
    public double getTrueNegativesFraction() {
        return this.getTrueNegativesCount() / this.getTotalCount();
    }

    @Override
    public double getFalseNegativesFraction() {
        return this.getFalseNegativesCount() / this.getTotalCount();
    }

    @Override
    public double getSensitivity() {
        double truePositivesCount = this.getTruePositivesCount();
        return truePositivesCount / (truePositivesCount + this.getFalseNegativesCount());
    }

    @Override
    public double getSpecificity() {
        double trueNegativesCount = this.getTrueNegativesCount();
        return trueNegativesCount / (trueNegativesCount + this.getFalsePositivesCount());
    }

    @Override
    public double getPrecision() {
        return this.getTruePositivesCount() / (this.getTruePositivesCount() + this.getFalsePositivesCount());
    }

    @Override
    public double getRecall() {
        return this.getTruePositivesCount() / (this.getTruePositivesCount() + this.getFalseNegativesCount());
    }

    @Override
    public double getFScore() {
        return this.getFScore(1.0);
    }

    @Override
    public double getFScore(double beta) {
        ArgumentChecker.assertIsNonNegative((String)"beta", (double)beta);
        double betaSquared = beta * beta;
        double precision = this.getPrecision();
        double recall = this.getRecall();
        return (1.0 + betaSquared) * (precision * recall) / (betaSquared * precision + recall);
    }
}

