/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.performance;

import gov.sandia.cognition.learning.data.TargetEstimatePair;
import gov.sandia.cognition.learning.function.cost.AbstractSupervisedCostFunction;
import java.util.Collection;

public class MeanZeroOneErrorEvaluator<InputType, DataType>
extends AbstractSupervisedCostFunction<InputType, DataType> {
    @Override
    public Double evaluatePerformance(Collection<? extends TargetEstimatePair<DataType, DataType>> data) {
        return MeanZeroOneErrorEvaluator.compute(data);
    }

    public static <DataType> double compute(Collection<? extends TargetEstimatePair<DataType, DataType>> data) {
        int count = data.size();
        if (count <= 0) {
            return 0.0;
        }
        int errorSum = 0;
        for (TargetEstimatePair<DataType, DataType> pair : data) {
            DataType estimate;
            DataType target = pair.getTarget();
            if (!(target == null ^ (estimate = pair.getEstimate()) == null) && (target == null || target.equals(estimate))) continue;
            ++errorSum;
        }
        return (double)errorSum / (double)count;
    }
}

