/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class VectorFunctionLinearDiscriminant<InputType>
extends AbstractCloneableSerializable
implements Evaluator<InputType, Double>,
Vectorizable {
    private Vector weightVector;
    private Evaluator<? super InputType, Vector> vectorFunction;

    public VectorFunctionLinearDiscriminant(Evaluator<? super InputType, Vector> vectorFunction, Vector weightVector) {
        this.setVectorFunction(vectorFunction);
        this.setWeightVector(weightVector);
    }

    public VectorFunctionLinearDiscriminant clone() {
        VectorFunctionLinearDiscriminant clone = (VectorFunctionLinearDiscriminant)super.clone();
        clone.setVectorFunction((Evaluator)ObjectUtil.cloneSmart(this.getVectorFunction()));
        clone.setWeightVector((Vector)ObjectUtil.cloneSafe((CloneableSerializable)this.getWeightVector()));
        return clone;
    }

    public Vector getWeightVector() {
        return this.weightVector;
    }

    public void setWeightVector(Vector weightVector) {
        this.weightVector = weightVector;
    }

    public Evaluator<? super InputType, Vector> getVectorFunction() {
        return this.vectorFunction;
    }

    public void setVectorFunction(Evaluator<? super InputType, Vector> vectorFunction) {
        this.vectorFunction = vectorFunction;
    }

    public Double evaluate(InputType input) {
        Vector vfOutput = (Vector)this.getVectorFunction().evaluate(input);
        return this.getWeightVector().dotProduct(vfOutput);
    }

    public Vector convertToVector() {
        return this.getWeightVector();
    }

    public void convertFromVector(Vector parameters) {
        this.setWeightVector(parameters);
    }
}

