/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.scalar;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.math.AbstractDifferentiableUnivariateScalarFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.Vectorizable;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2009-07-06", changesNeeded=false, comments={"Made clone() call super.clone().", "Minor clean up of javadoc.", "Otherwise, class looks fine."}), @CodeReview(reviewer={"Justin Basilico"}, date="2006-10-05", changesNeeded=false, comments={"Class looks fine."})})
public class AtanFunction
extends AbstractDifferentiableUnivariateScalarFunction
implements Vectorizable {
    protected static final double DEFAULT_MAX_MAGNITUDE = 1.5707963267948966;
    private static final double UNIT_SCALE = 0.6366197723675814;
    private double scaleFactor;

    public AtanFunction() {
        this(1.5707963267948966);
    }

    public AtanFunction(double maxMagnitude) {
        this.setMaxMagnitude(maxMagnitude);
    }

    public double evaluate(double input) {
        return Math.atan(input) * this.scaleFactor;
    }

    public double getMaxMagnitude() {
        return this.scaleFactor / 0.6366197723675814;
    }

    public void setMaxMagnitude(double maxMagnitude) {
        this.scaleFactor = maxMagnitude * 0.6366197723675814;
    }

    public double differentiate(double input) {
        double x = input;
        return this.scaleFactor / (1.0 + x * x);
    }

    public AtanFunction clone() {
        return (AtanFunction)super.clone();
    }

    public Vector convertToVector() {
        return VectorFactory.getDefault().copyValues(new double[]{this.getMaxMagnitude()});
    }

    public void convertFromVector(Vector parameters) {
        this.setMaxMagnitude(parameters.getElement(0));
    }
}

