/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.cost;

import gov.sandia.cognition.learning.function.cost.AbstractCostFunction;
import gov.sandia.cognition.statistics.ComputableDistribution;
import gov.sandia.cognition.statistics.ProbabilityFunction;
import java.util.Collection;

public class NegativeLogLikelihood<DataType>
extends AbstractCostFunction<ComputableDistribution<DataType>, Collection<? extends DataType>> {
    public NegativeLogLikelihood() {
        this(null);
    }

    public NegativeLogLikelihood(Collection<? extends DataType> costParameters) {
        super(costParameters);
    }

    @Override
    public Double evaluate(ComputableDistribution<DataType> target) {
        ProbabilityFunction<DataType> f = target.getProbabilityFunction();
        return NegativeLogLikelihood.evaluate(f, (Collection)this.getCostParameters());
    }

    public static <DataType> double evaluate(ProbabilityFunction<DataType> f, Collection<? extends DataType> data) {
        double logSum = 0.0;
        int N = data.size();
        for (DataType observation : data) {
            logSum += f.logEvaluate(observation) / (double)N;
        }
        return -logSum;
    }
}

