/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.cost;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.DefaultWeightedTargetEstimatePair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.data.TargetEstimatePair;
import gov.sandia.cognition.learning.function.cost.SupervisedCostFunction;
import gov.sandia.cognition.learning.performance.AbstractSupervisedPerformanceEvaluator;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractSupervisedCostFunction<InputType, TargetType>
extends AbstractSupervisedPerformanceEvaluator<InputType, TargetType, TargetType, Double>
implements SupervisedCostFunction<InputType, TargetType> {
    private Collection<? extends InputOutputPair<? extends InputType, TargetType>> costParameters;

    public AbstractSupervisedCostFunction() {
        this.setCostParameters(null);
    }

    public AbstractSupervisedCostFunction(Collection<? extends InputOutputPair<? extends InputType, TargetType>> costParameters) {
        this.setCostParameters(costParameters);
    }

    @Override
    public AbstractSupervisedCostFunction<InputType, TargetType> clone() {
        AbstractSupervisedCostFunction clone = (AbstractSupervisedCostFunction)super.clone();
        clone.setCostParameters(ObjectUtil.cloneSmartElementsAsArrayList((Collection)this.getCostParameters()));
        return clone;
    }

    @Override
    public abstract Double evaluatePerformance(Collection<? extends TargetEstimatePair<TargetType, TargetType>> var1);

    @Override
    public Double evaluate(Evaluator<? super InputType, ? extends TargetType> evaluator) {
        ArrayList targetEstimatePairs = new ArrayList(this.getCostParameters().size());
        Iterator i$ = this.getCostParameters().iterator();
        while (i$.hasNext()) {
            InputOutputPair io = (InputOutputPair)i$.next();
            Object estimate = evaluator.evaluate(io.getInput());
            targetEstimatePairs.add(DefaultWeightedTargetEstimatePair.create(io.getOutput(), estimate, DatasetUtil.getWeight(io)));
        }
        return this.evaluatePerformance((Collection)targetEstimatePairs);
    }

    @Override
    public Collection<? extends InputOutputPair<? extends InputType, TargetType>> getCostParameters() {
        return this.costParameters;
    }

    @Override
    public void setCostParameters(Collection<? extends InputOutputPair<? extends InputType, TargetType>> costParameters) {
        this.costParameters = costParameters;
    }

    @Override
    public Double summarize(Collection<? extends TargetEstimatePair<TargetType, TargetType>> data) {
        return this.evaluatePerformance((Collection)data);
    }
}

