/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.DefaultWeightedValueDiscriminant;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.DiscriminantCategorizer;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.statistics.AbstractDistribution;
import gov.sandia.cognition.statistics.ComputableDistribution;
import gov.sandia.cognition.statistics.PointMassDistribution;
import gov.sandia.cognition.statistics.ProbabilityFunction;
import gov.sandia.cognition.statistics.distribution.MapBasedPointMassDistribution;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.WeightedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;

@PublicationReference(author={"Wikipedia"}, title="Maximum a posteriori estimation", type=PublicationType.WebPage, year=2010, url="http://en.wikipedia.org/wiki/Maximum_a_posteriori_estimation")
public class MaximumAPosterioriCategorizer<ObservationType, CategoryType>
extends AbstractDistribution<ObservationType>
implements DiscriminantCategorizer<ObservationType, CategoryType, Double> {
    PointMassDistribution.PMF<CategoryType> categoryPriors = new MapBasedPointMassDistribution.PMF<CategoryType>(2);
    Map<CategoryType, ProbabilityFunction<ObservationType>> categoryConditionals = new HashMap<CategoryType, ProbabilityFunction<ObservationType>>(2);

    public MaximumAPosterioriCategorizer<ObservationType, CategoryType> clone() {
        return (MaximumAPosterioriCategorizer)super.clone();
    }

    public void addCategory(CategoryType category, double mass, ProbabilityFunction<ObservationType> conditional) {
        this.categoryPriors.add(category, mass);
        this.categoryConditionals.put(category, conditional);
    }

    public WeightedValue<ProbabilityFunction<ObservationType>> getCategory(CategoryType category) {
        ProbabilityFunction<ObservationType> conditional = this.categoryConditionals.get(category);
        double prior = (Double)this.categoryPriors.evaluate(category);
        return new DefaultWeightedValue(conditional, prior);
    }

    @Override
    public Set<? extends CategoryType> getCategories() {
        return this.categoryConditionals.keySet();
    }

    public CategoryType evaluate(ObservationType input) {
        return (CategoryType)this.evaluateWithDiscriminant((Object)input).getValue();
    }

    public DefaultWeightedValueDiscriminant<CategoryType> evaluateWithDiscriminant(ObservationType input) {
        Object maxCategory = null;
        double maxPosterior = Double.NEGATIVE_INFINITY;
        for (CategoryType category : this.getCategories()) {
            double posterior = this.computePosterior(input, category);
            if (!(maxPosterior < posterior)) continue;
            maxPosterior = posterior;
            maxCategory = category;
        }
        return DefaultWeightedValueDiscriminant.create(maxCategory, maxPosterior);
    }

    public double computePosterior(ObservationType observation, CategoryType category) {
        double posterior;
        ProbabilityFunction<ObservationType> categoryConditional = this.categoryConditionals.get(category);
        if (categoryConditional != null) {
            double prior = (Double)this.categoryPriors.evaluate(category);
            double conditional = (Double)categoryConditional.evaluate(observation);
            posterior = conditional * prior;
        } else {
            posterior = 0.0;
        }
        return posterior;
    }

    public ObservationType getMean() {
        Double mean = null;
        for (CategoryType category : this.getCategories()) {
            ObservationType categoryMean = this.getMean();
            double prior = (Double)this.categoryPriors.evaluate(category);
            if (categoryMean instanceof Number) {
                if (mean == null) {
                    mean = new Double(0.0);
                }
                double weightedCategoryMean = prior * ((Number)categoryMean).doubleValue();
                mean = new Double(((Number)mean).doubleValue() + weightedCategoryMean);
                continue;
            }
            if (categoryMean instanceof Ring) {
                Ring weightedCategoryMean = ((Ring)categoryMean).scale(prior);
                if (mean == null) {
                    mean = weightedCategoryMean;
                    continue;
                }
                ((Ring)mean).plusEquals(weightedCategoryMean);
                continue;
            }
            throw new UnsupportedOperationException("Mean not supported for type " + categoryMean.getClass());
        }
        return (ObservationType)mean;
    }

    @Override
    public ArrayList<? extends ObservationType> sample(Random random, int numSamples) {
        ArrayList categories = this.categoryPriors.sample(random, numSamples);
        ArrayList observations = new ArrayList(numSamples);
        for (Object category : categories) {
            ProbabilityFunction<ObservationType> pdf = this.categoryConditionals.get(category);
            observations.add(pdf.sample(random));
        }
        return observations;
    }

    public static class Learner<ObservationType, CategoryType>
    extends AbstractCloneableSerializable
    implements SupervisedBatchLearner<ObservationType, CategoryType, MaximumAPosterioriCategorizer<ObservationType, CategoryType>> {
        private BatchLearner<Collection<? extends ObservationType>, ? extends ComputableDistribution<ObservationType>> conditionalLearner;

        public Learner() {
            this(null);
        }

        public Learner(BatchLearner<Collection<? extends ObservationType>, ? extends ComputableDistribution<ObservationType>> conditionalLearner) {
            this.conditionalLearner = conditionalLearner;
        }

        public Learner<ObservationType, CategoryType> clone() {
            Learner clone = (Learner)super.clone();
            clone.setConditionalLearner((BatchLearner)ObjectUtil.cloneSmart(this.getConditionalLearner()));
            return clone;
        }

        @Override
        public MaximumAPosterioriCategorizer<ObservationType, CategoryType> learn(Collection<? extends InputOutputPair<? extends ObservationType, CategoryType>> data) {
            MapBasedPointMassDistribution.PMF<Object> categoryPrior = new MapBasedPointMassDistribution.PMF<Object>();
            HashMap<CategoryType, LinkedList<ObservationType>> categoryData = new HashMap<CategoryType, LinkedList<ObservationType>>();
            for (InputOutputPair<ObservationType, CategoryType> pair : data) {
                categoryPrior.add(pair.getOutput(), 1.0);
                LinkedList<ObservationType> categoryValues = (LinkedList<ObservationType>)categoryData.get(pair.getOutput());
                if (categoryValues == null) {
                    categoryValues = new LinkedList<ObservationType>();
                    categoryData.put(pair.getOutput(), categoryValues);
                }
                categoryValues.add(pair.getInput());
            }
            MaximumAPosterioriCategorizer categorizer = new MaximumAPosterioriCategorizer();
            for (Object category : categoryPrior.getDomain()) {
                LinkedList categoryValues = (LinkedList)categoryData.get(category);
                ComputableDistribution<ObservationType> distribution = this.conditionalLearner.learn(categoryValues);
                ProbabilityFunction<ObservationType> conditional = distribution.getProbabilityFunction();
                categorizer.addCategory(category, categoryPrior.getMass(category), conditional);
            }
            return categorizer;
        }

        public BatchLearner<Collection<? extends ObservationType>, ? extends ComputableDistribution<ObservationType>> getConditionalLearner() {
            return this.conditionalLearner;
        }

        public void setConditionalLearner(BatchLearner<Collection<? extends ObservationType>, ? extends ComputableDistribution<ObservationType>> conditionalLearner) {
            this.conditionalLearner = conditionalLearner;
        }
    }
}

