/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.function.categorization;

import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.learning.data.DefaultWeightedValueDiscriminant;
import gov.sandia.cognition.learning.function.categorization.DiscriminantCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class LinearMultiCategorizer<CategoryType>
extends AbstractCloneableSerializable
implements DiscriminantCategorizer<Vectorizable, CategoryType, Double>,
VectorInputEvaluator<Vectorizable, CategoryType> {
    protected Map<CategoryType, LinearBinaryCategorizer> prototypes;

    public LinearMultiCategorizer() {
        this(new LinkedHashMap());
    }

    public LinearMultiCategorizer(Map<CategoryType, LinearBinaryCategorizer> prototypes) {
        this.setPrototypes(prototypes);
    }

    public LinearMultiCategorizer<CategoryType> clone() {
        LinearMultiCategorizer clone = (LinearMultiCategorizer)super.clone();
        if (this.prototypes != null) {
            clone.prototypes = new LinkedHashMap<CategoryType, LinearBinaryCategorizer>(this.prototypes.size());
            for (CategoryType category : this.prototypes.keySet()) {
                clone.prototypes.put(category, this.prototypes.get(category).clone());
            }
        }
        return clone;
    }

    public CategoryType evaluate(Vectorizable input) {
        return (CategoryType)this.evaluateWithDiscriminant(input).getValue();
    }

    public DefaultWeightedValueDiscriminant<CategoryType> evaluateWithDiscriminant(Vectorizable input) {
        Vector inputVector = input.convertToVector();
        double bestScore = 0.0;
        Object bestCategory = null;
        for (CategoryType category : this.getCategories()) {
            double score = this.evaluateAsDouble(inputVector, category);
            if (bestCategory != null && !(score > bestScore)) continue;
            bestScore = score;
            bestCategory = category;
        }
        return new DefaultWeightedValueDiscriminant<Object>(bestCategory, bestScore);
    }

    public double evaluateAsDouble(Vectorizable input, CategoryType category) {
        return this.evaluateAsDouble(input.convertToVector(), category);
    }

    public double evaluateAsDouble(Vector input, CategoryType category) {
        LinearBinaryCategorizer prototype = this.prototypes.get(category);
        if (prototype == null) {
            return 0.0;
        }
        return prototype.evaluateAsDouble(input);
    }

    @Override
    public Set<? extends CategoryType> getCategories() {
        return this.prototypes.keySet();
    }

    public int getInputDimensionality() {
        LinearBinaryCategorizer firstPrototype = (LinearBinaryCategorizer)CollectionUtil.getFirst(this.prototypes.values());
        if (firstPrototype == null) {
            return -1;
        }
        return firstPrototype.getInputDimensionality();
    }

    public Map<CategoryType, LinearBinaryCategorizer> getPrototypes() {
        return this.prototypes;
    }

    public void setPrototypes(Map<CategoryType, LinearBinaryCategorizer> prototypes) {
        this.prototypes = prototypes;
    }
}

