/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.experiment;

import gov.sandia.cognition.learning.data.PartitionedDataset;
import gov.sandia.cognition.learning.experiment.AbstractLearningExperiment;
import gov.sandia.cognition.learning.experiment.ValidationFoldCreator;
import java.util.Collection;

public abstract class AbstractValidationFoldExperiment<InputDataType, FoldDataType>
extends AbstractLearningExperiment {
    protected ValidationFoldCreator<InputDataType, FoldDataType> foldCreator;
    protected int numTrials;

    public AbstractValidationFoldExperiment() {
        this(null);
    }

    public AbstractValidationFoldExperiment(ValidationFoldCreator<InputDataType, FoldDataType> foldCreator) {
        this.setFoldCreator(foldCreator);
        this.setNumTrials(-1);
    }

    protected void runExperiment(Collection<PartitionedDataset<FoldDataType>> folds) {
        this.setNumTrials(folds.size());
        this.fireExperimentStarted();
        for (PartitionedDataset<FoldDataType> fold : folds) {
            this.fireTrialStarted();
            this.runTrial(fold);
            this.fireTrialEnded();
        }
        this.fireExperimentEnded();
    }

    protected abstract void runTrial(PartitionedDataset<FoldDataType> var1);

    public ValidationFoldCreator<InputDataType, FoldDataType> getFoldCreator() {
        return this.foldCreator;
    }

    public void setFoldCreator(ValidationFoldCreator<InputDataType, FoldDataType> foldCreator) {
        this.foldCreator = foldCreator;
    }

    @Override
    public int getNumTrials() {
        return this.numTrials;
    }

    protected void setNumTrials(int numTrials) {
        this.numTrials = numTrials;
    }
}

