/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class SequentialDataMultiPartitioner {
    public static <DataType> ArrayList<ArrayList<DataType>> create(Collection<? extends DataType> data, int numPartitions) {
        int numData = data.size();
        int numEach = data.size() / numPartitions;
        ArrayList<ArrayList<DataType>> retval = new ArrayList<ArrayList<DataType>>(numPartitions);
        int index = 0;
        Iterator<DataType> iterator = data.iterator();
        for (int n = 0; n < numPartitions; ++n) {
            int numThis = n < numPartitions - 1 ? numEach : numData - index;
            ArrayList<DataType> partition = new ArrayList<DataType>(numThis);
            for (int i = 0; i < numThis; ++i) {
                partition.add(iterator.next());
                ++index;
            }
            retval.add(partition);
        }
        return retval;
    }
}

