/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.data;

import gov.sandia.cognition.learning.data.DefaultPartitionedDataset;
import gov.sandia.cognition.learning.data.PartitionedDataset;
import gov.sandia.cognition.learning.data.RandomizedDataPartitioner;
import gov.sandia.cognition.math.Permutation;
import gov.sandia.cognition.util.AbstractRandomized;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class RandomDataPartitioner<DataType>
extends AbstractRandomized
implements RandomizedDataPartitioner<DataType> {
    public static final double DEFAULT_TRAINING_PERCENT = 0.5;
    protected double trainingPercent;

    public RandomDataPartitioner() {
        super(new Random());
        this.setTrainingPercent(0.5);
    }

    public RandomDataPartitioner(double trainingPercent, Random random) {
        super(random);
        this.setTrainingPercent(trainingPercent);
    }

    @Override
    public PartitionedDataset<DataType> createPartition(Collection<? extends DataType> data) {
        return RandomDataPartitioner.createPartition(data, this.getTrainingPercent(), this.getRandom());
    }

    public static <DataType> PartitionedDataset<DataType> createPartition(Collection<? extends DataType> data, double trainingPercent, Random random) {
        int numTotal = data.size();
        if (numTotal < 2) {
            throw new IllegalArgumentException("data must have at least 2 items");
        }
        RandomDataPartitioner.checkTrainingPercent(trainingPercent);
        int numTrain = Math.max(1, (int)(trainingPercent * (double)numTotal));
        ArrayList reordering = Permutation.createReordering(data, (Random)random);
        List trainingSet = reordering.subList(0, numTrain);
        List testingSet = reordering.subList(numTrain, numTotal);
        return new DefaultPartitionedDataset(trainingSet, testingSet);
    }

    public double getTrainingPercent() {
        return this.trainingPercent;
    }

    public void setTrainingPercent(double trainingPercent) {
        RandomDataPartitioner.checkTrainingPercent(trainingPercent);
        this.trainingPercent = trainingPercent;
    }

    protected static final void checkTrainingPercent(double trainingPercent) {
        if (trainingPercent <= 0.0 || trainingPercent >= 1.0) {
            throw new IllegalArgumentException("trainingPercent must be greater than 0.0 and less than 1.0");
        }
    }
}

