/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.tree;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.tree.AbstractVectorThresholdMaximumGainLearner;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;

@PublicationReference(author={"Wikipedia"}, title="Decision tree learning", year=2010, type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Decision_tree_learning#Gini_impurity")
public class VectorThresholdGiniImpurityLearner<OutputType>
extends AbstractVectorThresholdMaximumGainLearner<OutputType> {
    @Override
    public double computeSplitGain(MapBasedDataHistogram<OutputType> baseCounts, MapBasedDataHistogram<OutputType> positiveCounts, MapBasedDataHistogram<OutputType> negativeCounts) {
        double impurityBase = VectorThresholdGiniImpurityLearner.giniImpurity(baseCounts);
        double impurityPositive = VectorThresholdGiniImpurityLearner.giniImpurity(positiveCounts);
        double impurityNegative = VectorThresholdGiniImpurityLearner.giniImpurity(negativeCounts);
        int totalCount = baseCounts.getTotalCount();
        double proportionPositive = (double)positiveCounts.getTotalCount() / (double)totalCount;
        double proportionNegative = (double)negativeCounts.getTotalCount() / (double)totalCount;
        double gain = impurityBase - proportionPositive * impurityPositive - proportionNegative * impurityNegative;
        return gain;
    }

    public static <DataType> double giniImpurity(MapBasedDataHistogram<DataType> counts) {
        double sum = 0.0;
        for (Object value : counts.getDomain()) {
            double fraction = counts.getFraction(value);
            sum += fraction * (1.0 - fraction);
        }
        return sum;
    }
}

