/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.tree;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.algorithm.tree.AbstractDecisionTreeLearner;
import gov.sandia.cognition.learning.algorithm.tree.AbstractDecisionTreeNode;
import gov.sandia.cognition.learning.algorithm.tree.DeciderLearner;
import gov.sandia.cognition.learning.algorithm.tree.RegressionTree;
import gov.sandia.cognition.learning.algorithm.tree.RegressionTreeNode;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.Categorizer;
import gov.sandia.cognition.util.ArgumentChecker;
import java.util.Collection;

public class RegressionTreeLearner<InputType>
extends AbstractDecisionTreeLearner<InputType, Double>
implements SupervisedBatchLearner<InputType, Double, RegressionTree<InputType>> {
    public static final int DEFAULT_LEAF_COUNT_THRESHOLD = 4;
    public static final int DEFAULT_MAX_DEPTH = -1;
    protected BatchLearner<Collection<? extends InputOutputPair<? extends InputType, Double>>, ? extends Evaluator<? super InputType, Double>> regressionLearner;
    protected int leafCountThreshold;
    protected int maxDepth;

    public RegressionTreeLearner() {
        this(null, null);
    }

    public RegressionTreeLearner(DeciderLearner<? super InputType, Double, ?, ?> deciderLearner, BatchLearner<Collection<? extends InputOutputPair<? extends InputType, Double>>, ? extends Evaluator<? super InputType, Double>> regressionLearner) {
        this(deciderLearner, regressionLearner, 4, -1);
    }

    public RegressionTreeLearner(DeciderLearner<? super InputType, Double, ?, ?> deciderLearner, BatchLearner<Collection<? extends InputOutputPair<? extends InputType, Double>>, ? extends Evaluator<? super InputType, Double>> regressionLearner, int leafCountThreshold, int maxDepth) {
        super(deciderLearner);
        this.setRegressionLearner(regressionLearner);
        this.setLeafCountThreshold(leafCountThreshold);
        this.setMaxDepth(maxDepth);
    }

    @Override
    public RegressionTree<InputType> learn(Collection<? extends InputOutputPair<? extends InputType, Double>> data) {
        if (data == null) {
            return null;
        }
        return new RegressionTree(this.learnNode((Collection)data, (AbstractDecisionTreeNode)null));
    }

    protected RegressionTreeNode<InputType, ?> learnNode(Collection<? extends InputOutputPair<? extends InputType, Double>> data, AbstractDecisionTreeNode<InputType, Double, ?> parent) {
        if (data == null || data.size() <= 0) {
            return null;
        }
        int depth = parent == null ? 1 : 1 + parent.getDepth();
        boolean isLeaf = data.size() <= this.leafCountThreshold || this.maxDepth > 0 && depth >= this.maxDepth || this.areAllOutputsEqual(data);
        double mean = DatasetUtil.computeOutputMean(data);
        Categorizer decider = null;
        if (!isLeaf) {
            decider = (Categorizer)this.getDeciderLearner().learn(data);
        }
        if (isLeaf || decider == null) {
            Evaluator<? super InputType, Double> scalarFunction = null;
            if (this.regressionLearner != null) {
                scalarFunction = this.regressionLearner.learn(data);
            }
            return new RegressionTreeNode(parent, scalarFunction, mean);
        }
        RegressionTreeNode node = new RegressionTreeNode(parent, decider, mean);
        this.learnChildNodes(node, data, decider);
        return node;
    }

    public BatchLearner<Collection<? extends InputOutputPair<? extends InputType, Double>>, ? extends Evaluator<? super InputType, Double>> getRegressionLearner() {
        return this.regressionLearner;
    }

    public void setRegressionLearner(BatchLearner<Collection<? extends InputOutputPair<? extends InputType, Double>>, ? extends Evaluator<? super InputType, Double>> regressionLearner) {
        this.regressionLearner = regressionLearner;
    }

    public int getLeafCountThreshold() {
        return this.leafCountThreshold;
    }

    public void setLeafCountThreshold(int leafCountThreshold) {
        ArgumentChecker.assertIsNonNegative((String)"leafCountThreshold", (int)leafCountThreshold);
        this.leafCountThreshold = leafCountThreshold;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }
}

