/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.tree;

import gov.sandia.cognition.learning.algorithm.tree.DecisionTreeNode;
import gov.sandia.cognition.learning.function.categorization.Categorizer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractDecisionTreeNode<InputType, OutputType, InteriorType>
implements DecisionTreeNode<InputType, OutputType>,
Serializable {
    protected DecisionTreeNode<InputType, OutputType> parent;
    protected Map<InteriorType, DecisionTreeNode<InputType, OutputType>> childMap;
    protected Categorizer<? super InputType, ? extends InteriorType> decider;
    protected Object incomingValue;

    public AbstractDecisionTreeNode() {
        this(null, null, null);
    }

    public AbstractDecisionTreeNode(DecisionTreeNode<InputType, OutputType> parent, Categorizer<? super InputType, ? extends InteriorType> decider, Object incomingValue) {
        this.setParent(parent);
        this.setDecider(decider);
        this.setChildMap(null);
        this.setIncomingValue(incomingValue);
    }

    public AbstractDecisionTreeNode<InputType, OutputType, InteriorType> clone() {
        try {
            return (AbstractDecisionTreeNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void addChild(InteriorType value, DecisionTreeNode<InputType, OutputType> child) {
        if (this.childMap == null) {
            this.childMap = new LinkedHashMap<InteriorType, DecisionTreeNode<InputType, OutputType>>();
        }
        this.childMap.put(value, child);
    }

    @Override
    public Collection<? extends DecisionTreeNode<InputType, OutputType>> getChildren() {
        if (this.isLeaf()) {
            return Collections.emptyList();
        }
        return this.childMap.values();
    }

    @Override
    public boolean isLeaf() {
        return this.childMap == null || this.childMap.size() <= 0;
    }

    @Override
    public DecisionTreeNode<InputType, OutputType> chooseChild(InputType input) {
        if (this.isLeaf() || this.decider == null) {
            return null;
        }
        Object decision = this.decider.evaluate(input);
        if (decision == null) {
            return null;
        }
        return this.childMap.get(decision);
    }

    @Override
    public int getDepth() {
        return this.parent == null ? 1 : 1 + this.parent.getDepth();
    }

    @Override
    public int getTreeSize() {
        int size = 1;
        for (DecisionTreeNode<InputType, OutputType> child : this.getChildren()) {
            size += child.getTreeSize();
        }
        return size;
    }

    @Override
    public DecisionTreeNode<InputType, OutputType> getParent() {
        return this.parent;
    }

    public void setParent(DecisionTreeNode<InputType, OutputType> parent) {
        this.parent = parent;
    }

    public Categorizer<? super InputType, ? extends InteriorType> getDecider() {
        return this.decider;
    }

    public void setDecider(Categorizer<? super InputType, ? extends InteriorType> decider) {
        this.decider = decider;
    }

    public Map<InteriorType, DecisionTreeNode<InputType, OutputType>> getChildMap() {
        return this.childMap;
    }

    protected void setChildMap(Map<InteriorType, DecisionTreeNode<InputType, OutputType>> childMap) {
        this.childMap = childMap;
    }

    @Override
    public Object getIncomingValue() {
        return this.incomingValue;
    }

    public void setIncomingValue(Object incomingValue) {
        this.incomingValue = incomingValue;
    }
}

