/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.root;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.root.AbstractBracketedRootFinder;
import gov.sandia.cognition.learning.data.InputOutputPair;

@PublicationReference(author={"Wikipedia"}, title="Secant method", type=PublicationType.WebPage, year=2009, url="http://en.wikipedia.org/wiki/Secant_method")
public class RootFinderSecantMethod
extends AbstractBracketedRootFinder {
    private InputOutputSlopeTriplet previousPoint;
    public static final double MAX_STEP = 1.0;

    @Override
    protected boolean initializeAlgorithm() {
        double input = this.getInitialGuess();
        Evaluator f = (Evaluator)this.data;
        double forig = (Double)f.evaluate((Object)input);
        double delta = 1.0;
        double fdelta = (Double)f.evaluate((Object)(input + 1.0));
        double slope = (fdelta - forig) / 1.0;
        this.previousPoint = new InputOutputSlopeTriplet(input, forig, slope);
        this.setRootBracket(new LineBracket(null, null, this.previousPoint));
        return slope != 0.0;
    }

    @Override
    protected boolean step() {
        double xn;
        double fn;
        double dn;
        double dnm1;
        double xnm1 = (Double)this.previousPoint.getInput();
        double fnm1 = (Double)this.previousPoint.getOutput();
        double delta = fnm1 / (dnm1 = this.previousPoint.getSlope().doubleValue());
        if (Math.abs(delta) > 1.0) {
            delta = 1.0 * Math.signum(delta);
        }
        if ((dn = ((fn = ((Double)((Evaluator)this.data).evaluate((Object)(xn = xnm1 - delta))).doubleValue()) - fnm1) / (xn - xnm1)) == 0.0) {
            return false;
        }
        this.previousPoint = new InputOutputSlopeTriplet(xn, fn, dn);
        return fn == 0.0 || Math.abs(delta) >= this.getTolerance();
    }

    @Override
    public InputOutputPair<Double, Double> getResult() {
        return this.previousPoint;
    }
}

