/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.regression;

import gov.sandia.cognition.learning.algorithm.AbstractAnytimeSupervisedBatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchCostMinimizationLearner;
import gov.sandia.cognition.learning.algorithm.regression.ParameterCostMinimizer;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.cost.SupervisedCostFunction;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorizableVectorFunction;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.Collection;

public abstract class AbstractParameterCostMinimizer<ResultType extends VectorizableVectorFunction, CostFunctionType extends SupervisedCostFunction<Vector, Vector>>
extends AbstractAnytimeSupervisedBatchLearner<Vector, Vector, ResultType>
implements BatchCostMinimizationLearner<Collection<? extends InputOutputPair<? extends Vector, Vector>>, ResultType>,
ParameterCostMinimizer<ResultType> {
    public static final double DEFAULT_TOLERANCE = 1.0E-7;
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    private ResultType objectToOptimize;
    private ResultType result;
    private double tolerance;
    private CostFunctionType costFunction;
    private Double resultCost;

    public AbstractParameterCostMinimizer(CostFunctionType costFunction, int maxIterations, double tolerance) {
        super(maxIterations);
        this.setCostFunction(costFunction);
        this.setTolerance(tolerance);
        this.setResultCost(null);
    }

    @Override
    public ResultType getObjectToOptimize() {
        return this.objectToOptimize;
    }

    @Override
    public void setObjectToOptimize(ResultType objectToOptimize) {
        this.objectToOptimize = objectToOptimize;
    }

    public ResultType getResult() {
        return this.result;
    }

    protected void setResult(ResultType result) {
        this.result = result;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public CostFunctionType getCostFunction() {
        return this.costFunction;
    }

    public void setCostFunction(CostFunctionType costFunction) {
        this.costFunction = costFunction;
    }

    protected Double getResultCost() {
        return this.resultCost;
    }

    protected void setResultCost(Double resultCost) {
        this.resultCost = resultCost;
    }

    public NamedValue<Double> getPerformance() {
        return new DefaultNamedValue(ObjectUtil.getShortClassName((Object)this.getCostFunction()), (Object)this.getResultCost());
    }
}

