/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron.kernel;

import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeSupervisedBatchLearner;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.KernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.kernel.Kernel;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.NamedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Added PublicationReference to the original article.", "Minor changes to javadoc.", "Looks fine."})
@PublicationReference(author={"Thilo-Thomas Friess", "Nello Cristianini", "Colin Campbell"}, title="The Kernel-Adatron Algorithm: A Fast and Simple Learning Procedure for Support Vector Machines", type=PublicationType.Conference, publication="Proceedings of the Fifteenth International Conference on Machine Learning", year=1998, pages={188, 196})
public class KernelAdatron<InputType>
extends AbstractAnytimeSupervisedBatchLearner<InputType, Boolean, KernelBinaryCategorizer<InputType, DefaultWeightedValue<InputType>>>
implements MeasurablePerformanceAlgorithm {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    private Kernel<? super InputType> kernel;
    private KernelBinaryCategorizer<InputType, DefaultWeightedValue<InputType>> result;
    private int errorCount;
    private LinkedHashMap<InputOutputPair<? extends InputType, Boolean>, DefaultWeightedValue<InputType>> supportsMap;

    public KernelAdatron() {
        this(null);
    }

    public KernelAdatron(Kernel<? super InputType> kernel) {
        this(kernel, 100);
    }

    public KernelAdatron(Kernel<? super InputType> kernel, int maxIterations) {
        super(maxIterations);
        this.setKernel(kernel);
        this.setLearned(null);
        this.setErrorCount(0);
        this.setSupportsMap(null);
    }

    @Override
    protected boolean initializeAlgorithm() {
        if (this.getData() == null) {
            return false;
        }
        int validCount = 0;
        for (InputOutputPair example : (Collection)this.getData()) {
            if (example == null) continue;
            ++validCount;
        }
        if (validCount <= 0) {
            return false;
        }
        this.setErrorCount(validCount);
        this.setSupportsMap(new LinkedHashMap<InputOutputPair<? extends InputType, Boolean>, DefaultWeightedValue<InputType>>());
        this.setLearned(new DefaultKernelBinaryCategorizer<InputType>(this.getKernel(), this.getSupportsMap().values(), 0.0));
        return true;
    }

    @Override
    protected boolean step() {
        this.setErrorCount(0);
        for (InputOutputPair example : (Collection)this.getData()) {
            double newWeight;
            double difference;
            if (example == null) continue;
            Object input = example.getInput();
            boolean actual = (Boolean)example.getOutput();
            double actualDouble = actual ? 1.0 : -1.0;
            double prediction = this.result.evaluateAsDouble(input);
            DefaultWeightedValue support = this.supportsMap.get(example);
            double oldWeight = support == null ? 0.0 : support.getWeight();
            double oldAlpha = actualDouble * oldWeight;
            double alpha = oldAlpha + (1.0 - actualDouble * prediction) / this.kernel.evaluate(input, input);
            if (alpha < 0.0) {
                alpha = 0.0;
            }
            if ((difference = (newWeight = actualDouble * alpha) - oldWeight) == 0.0) continue;
            this.setErrorCount(this.getErrorCount() + 1);
            double oldBias = this.result.getBias();
            double newBias = oldBias + difference;
            if (support == null) {
                support = new DefaultWeightedValue(input, newWeight);
                this.supportsMap.put(example, support);
            } else if (newWeight == 0.0) {
                this.supportsMap.remove(example);
            } else {
                support.setWeight(newWeight);
            }
            this.result.setBias(newBias);
        }
        return this.getErrorCount() > 0;
    }

    @Override
    protected void cleanupAlgorithm() {
        if (this.getSupportsMap() != null) {
            ((KernelBinaryCategorizer)this.getResult()).setExamples(new ArrayList<DefaultWeightedValue<InputType>>(this.getSupportsMap().values()));
            this.setSupportsMap(null);
        }
    }

    public Kernel<? super InputType> getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel<? super InputType> kernel) {
        this.kernel = kernel;
    }

    public KernelBinaryCategorizer<InputType, DefaultWeightedValue<InputType>> getResult() {
        return this.result;
    }

    protected void setLearned(KernelBinaryCategorizer<InputType, DefaultWeightedValue<InputType>> result) {
        this.result = result;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    protected void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }

    protected LinkedHashMap<InputOutputPair<? extends InputType, Boolean>, DefaultWeightedValue<InputType>> getSupportsMap() {
        return this.supportsMap;
    }

    protected void setSupportsMap(LinkedHashMap<InputOutputPair<? extends InputType, Boolean>, DefaultWeightedValue<InputType>> supportsMap) {
        this.supportsMap = supportsMap;
    }

    public NamedValue<Integer> getPerformance() {
        return new DefaultNamedValue("error count", (Object)this.getErrorCount());
    }
}

