/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.OnlinePassiveAggressivePerceptron;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;

@PublicationReference(title="Online Passive-Aggressive Algorithms on a Budget", author={"Zhuang Wang", "Slobodan Vucetic"}, year=2010, type=PublicationType.Conference, publication="Proceedings of the 13th International Conference on Artificial Intelligence and Statistics (AISTATS)", url="http://jmlr.csail.mit.edu/proceedings/papers/v9/wang10b/wang10b.pdf", notes={"This presents the PA-I-R algorithm. This implementation is non-budgeted form. We this also implements PA-R and PA-II-R"})
public class OnlineRampPassiveAggressivePerceptron
extends OnlinePassiveAggressivePerceptron.QuadraticSoftMargin {
    public OnlineRampPassiveAggressivePerceptron() {
        this(0.001);
    }

    public OnlineRampPassiveAggressivePerceptron(double aggressiveness) {
        this(aggressiveness, VectorFactory.getDefault());
    }

    public OnlineRampPassiveAggressivePerceptron(double aggressiveness, VectorFactory<?> vectorFactory) {
        super(aggressiveness, vectorFactory);
    }

    @Override
    public double computeUpdate(LinearBinaryCategorizer target, Vector input, boolean actualCategory, double predicted) {
        double actual = actualCategory ? 1.0 : -1.0;
        double margin = actual * predicted;
        double hingeLoss = 1.0 - margin;
        if (Math.abs(margin) > 1.0) {
            return 0.0;
        }
        double inputNorm2Squared = input.norm2Squared();
        return this.computeUpdate(actual, predicted, hingeLoss, inputNorm2Squared);
    }

    @Override
    public <InputType> double computeUpdate(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean actualCategory, double predicted) {
        double actual = actualCategory ? 1.0 : -1.0;
        double margin = actual * predicted;
        double hingeLoss = 1.0 - margin;
        if (Math.abs(margin) > 1.0) {
            return 0.0;
        }
        double norm = target.getKernel().evaluate(input, input);
        return this.computeUpdate(actual, predicted, hingeLoss, norm);
    }
}

