/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.perceptron.AbstractLinearCombinationOnlineLearner;
import gov.sandia.cognition.learning.function.categorization.DefaultKernelBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;

@PublicationReference(author={"Wikipedia"}, title="Perceptron Learning algorithm", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/Perceptron#Learning_algorithm")
public class OnlinePerceptron
extends AbstractLinearCombinationOnlineLearner {
    public static final boolean DEFAULT_UPDATE_BIAS = true;

    public OnlinePerceptron() {
        this(VectorFactory.getDenseDefault());
    }

    public OnlinePerceptron(VectorFactory<?> vectorFactory) {
        super(true, vectorFactory);
    }

    @Override
    public double computeUpdate(LinearBinaryCategorizer target, Vector input, boolean label, double predicted) {
        return OnlinePerceptron.computeUpdate(label, predicted);
    }

    @Override
    public <InputType> double computeUpdate(DefaultKernelBinaryCategorizer<InputType> target, InputType input, boolean actualCategory, double predicted) {
        return OnlinePerceptron.computeUpdate(actualCategory, predicted);
    }

    public static double computeUpdate(boolean actualCategory, double predicted) {
        double actual;
        double d = actual = actualCategory ? 1.0 : -1.0;
        if (predicted * actual <= 0.0) {
            return 1.0;
        }
        return 0.0;
    }
}

