/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.perceptron;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.AbstractBatchAndIncrementalLearner;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.categorization.LinearBinaryCategorizer;
import gov.sandia.cognition.learning.function.categorization.LinearMultiCategorizer;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.math.matrix.VectorFactoryContainer;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.DefaultWeightedValue;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.LinkedList;

public class OnlineMultiPerceptron<CategoryType>
extends AbstractBatchAndIncrementalLearner<InputOutputPair<? extends Vectorizable, CategoryType>, LinearMultiCategorizer<CategoryType>>
implements VectorFactoryContainer {
    public static final double DEFAULT_MIN_MARGIN = 0.0;
    protected double minMargin;
    protected VectorFactory<?> vectorFactory;

    public OnlineMultiPerceptron() {
        this(0.0);
    }

    public OnlineMultiPerceptron(double minMargin) {
        this(minMargin, VectorFactory.getDefault());
    }

    public OnlineMultiPerceptron(double minMargin, VectorFactory<?> vectorFactory) {
        this.setMinMargin(minMargin);
        this.setVectorFactory(vectorFactory);
    }

    @Override
    public LinearMultiCategorizer<CategoryType> createInitialLearnedObject() {
        return new LinearMultiCategorizer();
    }

    @Override
    public void update(LinearMultiCategorizer<CategoryType> target, InputOutputPair<? extends Vectorizable, CategoryType> example) {
        Vector input = example.getInput().convertToVector();
        CategoryType actual = example.getOutput();
        boolean knownCategory = target.getCategories().contains(actual);
        if (!knownCategory) {
            Vector initialWeights = this.getVectorFactory().createVector(input.getDimensionality());
            target.getPrototypes().put(actual, new LinearBinaryCategorizer(initialWeights, 0.0));
        }
        Object predicted = null;
        double predictedScore = Double.NEGATIVE_INFINITY;
        for (CategoryType category : target.getCategories()) {
            double score = target.evaluateAsDouble(input, category);
            if (actual.equals(category)) {
                score -= this.minMargin;
            }
            if (!(score > predictedScore)) continue;
            predicted = category;
            predictedScore = score;
        }
        boolean correct = ObjectUtil.equalsSafe(actual, predicted);
        if (!correct) {
            LinearBinaryCategorizer actualPrototype = target.getPrototypes().get(actual);
            actualPrototype.getWeights().plusEquals((Ring)input);
            actualPrototype.setBias(actualPrototype.getBias() + 1.0);
            LinearBinaryCategorizer predictedPrototype = target.getPrototypes().get(predicted);
            predictedPrototype.getWeights().minusEquals((Ring)input);
            predictedPrototype.setBias(predictedPrototype.getBias() - 1.0);
        }
    }

    public double getMinMargin() {
        return this.minMargin;
    }

    public void setMinMargin(double minMargin) {
        ArgumentChecker.assertIsNonNegative((String)"minMargin", (double)minMargin);
        this.minMargin = minMargin;
    }

    public VectorFactory<?> getVectorFactory() {
        return this.vectorFactory;
    }

    public void setVectorFactory(VectorFactory<?> vectorFactory) {
        this.vectorFactory = vectorFactory;
    }

    @PublicationReference(title="Ultraconservative online algorithms for multiclass problems", author={"Koby Crammer", "Yoram Singer"}, year=2003, type=PublicationType.Journal, publication="The Journal of Machine Learning Research", pages={951, 991}, url="http://portal.acm.org/citation.cfm?id=944936")
    public static class ProportionalUpdate<CategoryType>
    extends OnlineMultiPerceptron<CategoryType> {
        public static final double DEFAULT_MIN_MARGIN = 0.001;

        public ProportionalUpdate() {
            this(0.001);
        }

        public ProportionalUpdate(double minMargin) {
            super(minMargin);
        }

        public ProportionalUpdate(double minMargin, VectorFactory<?> vectorFactory) {
            super(minMargin, vectorFactory);
        }

        @Override
        public void update(LinearMultiCategorizer<CategoryType> target, InputOutputPair<? extends Vectorizable, CategoryType> example) {
            Vector input = example.getInput().convertToVector();
            CategoryType actual = example.getOutput();
            boolean knownCategory = target.getCategories().contains(actual);
            if (!knownCategory) {
                Vector initialWeights = this.getVectorFactory().createVector(input.getDimensionality());
                target.getPrototypes().put(actual, new LinearBinaryCategorizer(initialWeights, 0.0));
            }
            double actualScore = target.evaluateAsDouble(input, actual) - this.minMargin;
            LinkedList<DefaultWeightedValue> errors = new LinkedList<DefaultWeightedValue>();
            double differenceSum = 0.0;
            for (CategoryType category : target.getCategories()) {
                double score = target.evaluateAsDouble(input, category);
                double difference = score - actualScore;
                if (!(difference >= 0.0) || actual.equals(category)) continue;
                errors.add(DefaultWeightedValue.create(category, (double)difference));
                differenceSum += difference;
            }
            boolean correct = errors.isEmpty();
            if (!correct) {
                LinearBinaryCategorizer actualPrototype = target.getPrototypes().get(actual);
                actualPrototype.getWeights().plusEquals((Ring)input);
                actualPrototype.setBias(actualPrototype.getBias() + 1.0);
                for (DefaultWeightedValue category : errors) {
                    LinearBinaryCategorizer prototype = target.getPrototypes().get(category.getValue());
                    double errorWeight = category.getWeight() / differenceSum;
                    prototype.getWeights().minusEquals(input.scale(errorWeight));
                    prototype.setBias(prototype.getBias() - errorWeight);
                }
            }
        }

        @Override
        public void setMinMargin(double minMargin) {
            ArgumentChecker.assertIsPositive((String)"minMargin", (double)minMargin);
            super.setMinMargin(minMargin);
        }
    }

    @PublicationReference(title="Ultraconservative online algorithms for multiclass problems", author={"Koby Crammer", "Yoram Singer"}, year=2003, type=PublicationType.Journal, publication="The Journal of Machine Learning Research", pages={951, 991}, url="http://portal.acm.org/citation.cfm?id=944936")
    public static class UniformUpdate<CategoryType>
    extends OnlineMultiPerceptron<CategoryType> {
        public UniformUpdate() {
        }

        public UniformUpdate(double minMargin) {
            super(minMargin);
        }

        public UniformUpdate(double minMargin, VectorFactory<?> vectorFactory) {
            super(minMargin, vectorFactory);
        }

        @Override
        public void update(LinearMultiCategorizer<CategoryType> target, InputOutputPair<? extends Vectorizable, CategoryType> example) {
            Vector input = example.getInput().convertToVector();
            CategoryType actual = example.getOutput();
            boolean knownCategory = target.getCategories().contains(actual);
            if (!knownCategory) {
                Vector initialWeights = this.getVectorFactory().createVector(input.getDimensionality());
                target.getPrototypes().put(actual, new LinearBinaryCategorizer(initialWeights, 0.0));
            }
            double actualScore = target.evaluateAsDouble(input, actual) - this.minMargin;
            LinkedList<CategoryType> errors = new LinkedList<CategoryType>();
            for (CategoryType category : target.getCategories()) {
                double score = target.evaluateAsDouble(input, category);
                if (actual.equals(category) || !(score >= actualScore)) continue;
                errors.add(category);
            }
            boolean correct = errors.isEmpty();
            if (!correct) {
                LinearBinaryCategorizer actualPrototype = target.getPrototypes().get(actual);
                actualPrototype.getWeights().plusEquals((Ring)input);
                actualPrototype.setBias(actualPrototype.getBias() + 1.0);
                double errorWeight = 1.0 / (double)errors.size();
                Vector errorUpdate = (Vector)input.scale(errorWeight);
                for (Object category : errors) {
                    LinearBinaryCategorizer prototype = target.getPrototypes().get(category);
                    prototype.getWeights().minusEquals((Ring)errorUpdate);
                    prototype.setBias(prototype.getBias() - errorWeight);
                }
            }
        }
    }
}

