/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization.line;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.minimization.line.AbstractAnytimeLineMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.InputOutputSlopeTriplet;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineBracket;
import gov.sandia.cognition.learning.algorithm.minimization.line.WolfeConditions;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.LineBracketInterpolator;
import gov.sandia.cognition.learning.algorithm.minimization.line.interpolator.LineBracketInterpolatorHermiteParabola;
import gov.sandia.cognition.math.AbstractDifferentiableUnivariateScalarFunction;
import gov.sandia.cognition.math.DifferentiableUnivariateScalarFunction;
import gov.sandia.cognition.util.ObjectUtil;

@PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={34, 39}, notes={"Equation 2.6.2 and Equation 2.6.4", "Fletcher assumes that the initial slope is negative (WOLOG), and this class automatically adjusts itself to positive-slope guesses."})
public class LineMinimizerDerivativeBased
extends AbstractAnytimeLineMinimizer<DifferentiableUnivariateScalarFunction> {
    public static final double DEFAULT_CURVATURE_CONDITION = 0.1;
    public static final double DEFAULT_SLOPE_CONDITION = 0.01;
    public static final LineBracketInterpolator<? super DifferentiableUnivariateScalarFunction> DEFAULT_INTERPOLATOR = new LineBracketInterpolatorHermiteParabola();
    private double minFunctionValue;
    public static final double DEFAULT_MIN_FUNCTION_VALUE = 0.0;
    private double direction;
    private InternalFunction internalFunction;
    private WolfeConditions wolfe;
    private double maxX;
    protected static final double TAU1 = 5.0;
    protected static final double TAU2 = 0.1;
    protected static final double TAU3 = 0.5;

    public LineMinimizerDerivativeBased() {
        this(0.0);
    }

    public LineMinimizerDerivativeBased(double minFunctionValue) {
        this((LineBracketInterpolator)ObjectUtil.cloneSafe(DEFAULT_INTERPOLATOR), minFunctionValue);
    }

    public LineMinimizerDerivativeBased(LineBracketInterpolator<? super DifferentiableUnivariateScalarFunction> interpolator, double minFunctionValue) {
        super(interpolator);
        this.setMinFunctionValue(minFunctionValue);
    }

    @Override
    protected boolean initializeAlgorithm() {
        boolean retval = super.initializeAlgorithm();
        this.internalFunction = new InternalFunction();
        this.setBracket(new LineBracket());
        Double initialGuessFunctionValue = this.getInitialGuessFunctionValue() != null ? this.getInitialGuessFunctionValue() : (Double)((DifferentiableUnivariateScalarFunction)this.data).evaluate(this.getInitialGuess());
        Double initialGuessSlope = this.getInitialGuessSlope() != null ? this.getInitialGuessSlope() : (Double)((DifferentiableUnivariateScalarFunction)this.data).differentiate(this.getInitialGuess());
        InputOutputSlopeTriplet initialTriplet = new InputOutputSlopeTriplet(this.internalFunction.convertInputToInternal((Double)this.getInitialGuess()), initialGuessFunctionValue, initialGuessSlope);
        double initialSlope = initialTriplet.getSlope();
        if (initialSlope < 0.0) {
            this.direction = 1.0;
        } else {
            this.direction = -1.0;
            initialTriplet.setSlope(initialSlope * this.direction);
        }
        this.getBracket().setLowerBound(initialTriplet);
        if (Math.abs(initialSlope) <= this.getTolerance() * 0.001) {
            this.result = this.internalFunction.convertInputFromInternal(initialTriplet);
            this.stop();
            return true;
        }
        this.wolfe = new WolfeConditions(initialTriplet, 0.01, 0.1);
        double denom = this.wolfe.getSlopeCondition() * initialTriplet.getSlope();
        this.maxX = (this.getMinFunctionValue() - (Double)initialTriplet.getOutput()) / denom;
        double nextX = 1.0;
        double fnextX = this.internalFunction.evaluate(nextX);
        this.getBracket().setUpperBound(new InputOutputSlopeTriplet(nextX, fnextX, null));
        return retval;
    }

    @Override
    public boolean bracketingStep() {
        double nextX;
        LineBracket bracket = this.getBracket();
        InputOutputSlopeTriplet previousPoint = bracket.getLowerBound();
        InputOutputSlopeTriplet currentPoint = bracket.getUpperBound();
        if ((Double)currentPoint.getOutput() < this.getMinFunctionValue()) {
            this.result = this.internalFunction.convertInputFromInternal(currentPoint);
            return true;
        }
        if (!this.wolfe.evaluateGoldsteinCondition(currentPoint) || (Double)currentPoint.getOutput() >= (Double)previousPoint.getOutput()) {
            bracket.setLowerBound(previousPoint);
            bracket.setUpperBound(currentPoint);
            return true;
        }
        if (currentPoint.getSlope() == null) {
            currentPoint.setSlope(this.internalFunction.differentiate((Double)currentPoint.getInput()));
        }
        if (this.wolfe.evaluateStrictCurvatureCondition(currentPoint.getSlope())) {
            this.result = this.internalFunction.convertInputFromInternal(currentPoint);
            return true;
        }
        if (currentPoint.getSlope() >= 0.0) {
            bracket.setLowerBound(currentPoint);
            bracket.setUpperBound(previousPoint);
            return true;
        }
        double delta = (Double)currentPoint.getInput() - (Double)previousPoint.getInput();
        double deltaPlusCurrent = (Double)currentPoint.getInput() + delta;
        if (this.maxX <= deltaPlusCurrent) {
            nextX = this.maxX;
        } else {
            double minx = deltaPlusCurrent;
            double maxx = Math.min(this.maxX, (Double)currentPoint.getInput() + 5.0 * delta);
            if (minx > maxx) {
                double temp = minx;
                minx = maxx;
                maxx = temp;
            }
            nextX = this.getInterpolator().findMinimum(bracket, minx, maxx, this.internalFunction);
        }
        bracket.setOtherPoint(previousPoint);
        bracket.setLowerBound(currentPoint);
        bracket.setUpperBound(new InputOutputSlopeTriplet(nextX, this.internalFunction.evaluate(nextX), null));
        return false;
    }

    @Override
    public boolean sectioningStep() {
        double maxx;
        LineBracket bracket = this.getBracket();
        InputOutputSlopeTriplet a = bracket.getLowerBound();
        InputOutputSlopeTriplet b = bracket.getUpperBound();
        double bracketDelta = (Double)b.getInput() - (Double)a.getInput();
        if (Math.abs(bracketDelta) < this.getTolerance()) {
            this.result = this.internalFunction.convertInputFromInternal((Double)a.getOutput() < (Double)b.getOutput() ? a : b);
            return false;
        }
        double minx = (Double)a.getInput() + 0.1 * bracketDelta;
        if (minx > (maxx = (Double)b.getInput() - 0.5 * bracketDelta)) {
            double temp = minx;
            minx = maxx;
            maxx = temp;
        }
        double alphaj = this.getInterpolator().findMinimum(bracket, minx, maxx, this.internalFunction);
        double falphaj = this.internalFunction.evaluate(alphaj);
        InputOutputSlopeTriplet currentPoint = new InputOutputSlopeTriplet(alphaj, falphaj, null);
        double midx = 0.5 * (minx + maxx);
        double convergenceThreshold = this.getTolerance() * Math.abs((Double)b.getInput()) - 0.5 * (maxx - minx);
        if (Math.abs(midx - alphaj) <= convergenceThreshold || falphaj < this.getMinFunctionValue()) {
            this.result = this.internalFunction.convertInputFromInternal(currentPoint);
            return false;
        }
        if (!this.wolfe.evaluateGoldsteinCondition(currentPoint) || falphaj >= (Double)a.getOutput()) {
            bracket.setOtherPoint(b);
            b = currentPoint;
        } else {
            if (currentPoint.getSlope() == null) {
                currentPoint.setSlope(this.internalFunction.differentiate(alphaj));
            }
            if (this.wolfe.evaluateStrictCurvatureCondition(currentPoint.getSlope())) {
                this.result = this.internalFunction.convertInputFromInternal(currentPoint);
                return false;
            }
            InputOutputSlopeTriplet previousA = a;
            bracket.setOtherPoint(previousA);
            a = currentPoint;
            if (bracketDelta * currentPoint.getSlope() >= 0.0) {
                bracket.setOtherPoint(b);
                b = previousA;
            }
        }
        bracket.setLowerBound(a);
        bracket.setUpperBound(b);
        return true;
    }

    public double getMinFunctionValue() {
        return this.minFunctionValue;
    }

    public void setMinFunctionValue(double minFunctionValue) {
        this.minFunctionValue = minFunctionValue;
    }

    public class InternalFunction
    extends AbstractDifferentiableUnivariateScalarFunction {
        public double convertInputToInternal(double input) {
            double x0 = (Double)LineMinimizerDerivativeBased.this.getInitialGuess();
            double internalInput = LineMinimizerDerivativeBased.this.direction * (input - x0);
            return internalInput;
        }

        protected double convertInputFromInternal(double internalInput) {
            double x0 = (Double)LineMinimizerDerivativeBased.this.getInitialGuess();
            double input = x0 + LineMinimizerDerivativeBased.this.direction * internalInput;
            return input;
        }

        public InputOutputSlopeTriplet convertInputFromInternal(InputOutputSlopeTriplet internalPoint) {
            InputOutputSlopeTriplet retval;
            double input = this.convertInputFromInternal((Double)internalPoint.getInput());
            if (LineMinimizerDerivativeBased.this.direction > 0.0) {
                retval = new InputOutputSlopeTriplet(input, (Double)internalPoint.getOutput(), internalPoint.getSlope());
            } else {
                Double m = internalPoint.getSlope() != null ? Double.valueOf(-internalPoint.getSlope().doubleValue()) : null;
                retval = new InputOutputSlopeTriplet(input, (Double)internalPoint.getOutput(), m);
            }
            return retval;
        }

        public double evaluate(double internalInput) {
            return ((DifferentiableUnivariateScalarFunction)LineMinimizerDerivativeBased.this.data).evaluate(this.convertInputFromInternal(internalInput));
        }

        public double differentiate(double internalInput) {
            return LineMinimizerDerivativeBased.this.direction * ((DifferentiableUnivariateScalarFunction)LineMinimizerDerivativeBased.this.data).differentiate(this.convertInputFromInternal(internalInput));
        }
    }
}

