/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.minimization;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.minimization.AbstractAnytimeFunctionMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.MinimizationStoppingCriterion;
import gov.sandia.cognition.learning.algorithm.minimization.line.DirectionalVectorToDifferentiableScalarFunction;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizer;
import gov.sandia.cognition.learning.algorithm.minimization.line.LineMinimizerDerivativeBased;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.math.DifferentiableEvaluator;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;

@PublicationReferences(references={@PublicationReference(author={"R. Fletcher"}, title="Practical Methods of Optimization, Second Edition", type=PublicationType.Book, year=1987, pages={80, 87}, notes={"Section 4.1"}), @PublicationReference(author={"Wikipedia"}, title="Nonlinear conjugate gradient method", type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Nonlinear_conjugate_gradient_method", year=2008), @PublicationReference(author={"William H. Press", "Saul A. Teukolsky", "William T. Vetterling", "Brian P. Flannery"}, title="Numerical Recipes in C, Second Edition", type=PublicationType.Book, year=1992, pages={423, 424}, notes={"Section 10.6"}, url="http://www.nrbook.com/a/bookcpdf.php")})
public abstract class FunctionMinimizerConjugateGradient
extends AbstractAnytimeFunctionMinimizer<Vector, Double, DifferentiableEvaluator<? super Vector, Double, Vector>> {
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    public static final double DEFAULT_TOLERANCE = 1.0E-5;
    private static final double TOLERANCE_DELTA_Y = 1.0E-10;
    public static final LineMinimizer<?> DEFAULT_LINE_MINIMIZER = new LineMinimizerDerivativeBased();
    private LineMinimizer<?> lineMinimizer;
    protected DirectionalVectorToDifferentiableScalarFunction lineFunction;
    private Vector gradient;

    public FunctionMinimizerConjugateGradient(LineMinimizer<?> lineMinimizer, Vector initialGuess, double tolerance, int maxIterations) {
        super(initialGuess, tolerance, maxIterations);
        this.setLineMinimizer(lineMinimizer);
    }

    public LineMinimizer<?> getLineMinimizer() {
        return this.lineMinimizer;
    }

    public void setLineMinimizer(LineMinimizer<?> lineMinimizer) {
        this.lineMinimizer = lineMinimizer;
    }

    @Override
    protected boolean initializeAlgorithm() {
        this.result = new DefaultInputOutputPair<Object, Object>(this.initialGuess, ((DifferentiableEvaluator)this.data).evaluate(this.initialGuess));
        this.gradient = (Vector)((DifferentiableEvaluator)this.data).differentiate(this.initialGuess);
        this.lineFunction = new DirectionalVectorToDifferentiableScalarFunction((DifferentiableEvaluator<? super Vector, ? extends Double, Vector>)((DifferentiableEvaluator)this.data), (Vector)this.initialGuess, (Vector)this.gradient.scale(-1.0));
        return true;
    }

    @Override
    protected boolean step() {
        DifferentiableEvaluator f = (DifferentiableEvaluator)this.data;
        Vector xold = (Vector)this.result.getInput();
        this.result = this.lineMinimizer.minimizeAlongDirection(this.lineFunction, (Double)this.result.getOutput(), this.gradient);
        Vector xnew = (Vector)this.result.getInput();
        double fnew = (Double)this.result.getOutput();
        Vector gradientOld = this.gradient;
        this.gradient = this.lineFunction.getLastGradient() != null && this.lineFunction.getLastGradient().getInput().equals(xnew) ? this.lineFunction.getLastGradient().getOutput() : (Vector)f.differentiate((Object)xnew);
        if (MinimizationStoppingCriterion.convergence(xnew, fnew, this.gradient, (Vector)xnew.minus((Ring)xold), this.getTolerance())) {
            return false;
        }
        int resetPeriod = this.gradient.getDimensionality() * 2;
        double beta = (this.getIteration() + 1) % resetPeriod == 0 ? 0.0 : this.computeScaleFactor(this.gradient, gradientOld);
        Vector newDirection = (Vector)((Vector)this.lineFunction.getDirection().scale(beta)).minus((Ring)this.gradient);
        this.lineFunction.setDirection(newDirection);
        this.lineFunction.setVectorOffset(xnew);
        return true;
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    protected abstract double computeScaleFactor(Vector var1, Vector var2);
}

