/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.hmm;

import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.learning.algorithm.hmm.HiddenMarkovModel;
import gov.sandia.cognition.statistics.ComputableDistribution;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.ObjectUtil;
import gov.sandia.cognition.util.WeightedValue;
import java.util.Collection;

public abstract class AbstractBaumWelchAlgorithm<ObservationType, DataType>
extends AbstractAnytimeBatchLearner<DataType, HiddenMarkovModel<ObservationType>>
implements MeasurablePerformanceAlgorithm {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    public static final boolean DEFAULT_REESTIMATE_INITIAL_PROBABILITY = true;
    public static final String PERFORMANCE_NAME = "Log Likelihood";
    protected BatchLearner<Collection<? extends WeightedValue<? extends ObservationType>>, ? extends ComputableDistribution<ObservationType>> distributionLearner;
    protected HiddenMarkovModel<ObservationType> result;
    protected HiddenMarkovModel<ObservationType> initialGuess;
    protected double lastLogLikelihood;
    protected boolean reestimateInitialProbabilities;

    public AbstractBaumWelchAlgorithm(HiddenMarkovModel<ObservationType> initialGuess, BatchLearner<Collection<? extends WeightedValue<? extends ObservationType>>, ? extends ComputableDistribution<ObservationType>> distributionLearner, boolean reestimateInitialProbabilities) {
        super(100);
        this.setInitialGuess(initialGuess);
        this.setDistributionLearner(distributionLearner);
        this.setReestimateInitialProbabilities(reestimateInitialProbabilities);
        this.result = null;
        this.lastLogLikelihood = Double.NEGATIVE_INFINITY;
    }

    @Override
    public AbstractBaumWelchAlgorithm<ObservationType, DataType> clone() {
        AbstractBaumWelchAlgorithm clone = (AbstractBaumWelchAlgorithm)super.clone();
        clone.setDistributionLearner((BatchLearner)ObjectUtil.cloneSafe(this.getDistributionLearner()));
        clone.result = (HiddenMarkovModel)ObjectUtil.cloneSafe((CloneableSerializable)this.getResult());
        clone.setInitialGuess((HiddenMarkovModel)ObjectUtil.cloneSafe(this.getInitialGuess()));
        return clone;
    }

    public NamedValue<Double> getPerformance() {
        return new DefaultNamedValue(PERFORMANCE_NAME, (Object)this.lastLogLikelihood);
    }

    public HiddenMarkovModel<ObservationType> getResult() {
        return this.result;
    }

    public HiddenMarkovModel<ObservationType> getInitialGuess() {
        return this.initialGuess;
    }

    public void setInitialGuess(HiddenMarkovModel<ObservationType> initialGuess) {
        this.initialGuess = initialGuess;
    }

    public boolean getReestimateInitialProbabilities() {
        return this.reestimateInitialProbabilities;
    }

    public void setReestimateInitialProbabilities(boolean reestimateInitialProbabilities) {
        this.reestimateInitialProbabilities = reestimateInitialProbabilities;
    }

    public BatchLearner<Collection<? extends WeightedValue<? extends ObservationType>>, ? extends ComputableDistribution<ObservationType>> getDistributionLearner() {
        return this.distributionLearner;
    }

    public void setDistributionLearner(BatchLearner<Collection<? extends WeightedValue<? extends ObservationType>>, ? extends ComputableDistribution<ObservationType>> distributionLearner) {
        this.distributionLearner = distributionLearner;
    }
}

