/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.ensemble;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.AbstractSupervisedBatchAndIncrementalLearner;
import gov.sandia.cognition.learning.algorithm.IncrementalLearner;
import gov.sandia.cognition.learning.algorithm.ensemble.VotingCategorizerEnsemble;
import gov.sandia.cognition.learning.data.DefaultInputOutputPair;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.statistics.distribution.PoissonDistribution;
import gov.sandia.cognition.util.ArgumentChecker;
import gov.sandia.cognition.util.Randomized;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Random;

@PublicationReference(author={"Nikunj C. Oza", "Stuart Russell"}, title="Online Bagging and Boosting", year=2001, type=PublicationType.Conference, publication="In Artificial Intelligence and Statistics", pages={105, 112}, url="http://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.32.8889")
public class OnlineBaggingCategorizerLearner<InputType, CategoryType, MemberType extends Evaluator<? super InputType, ? extends CategoryType>>
extends AbstractSupervisedBatchAndIncrementalLearner<InputType, CategoryType, VotingCategorizerEnsemble<InputType, CategoryType, MemberType>>
implements Randomized {
    public static final int DEFAULT_ENSEMBLE_SIZE = 100;
    public static final double DEFAULT_PERCENT_TO_SAMPLE = 1.0;
    protected IncrementalLearner<? super InputOutputPair<? extends InputType, CategoryType>, MemberType> learner;
    protected int ensembleSize;
    protected double percentToSample;
    protected Random random;

    public OnlineBaggingCategorizerLearner() {
        this(null);
    }

    public OnlineBaggingCategorizerLearner(IncrementalLearner<? super InputOutputPair<? extends InputType, CategoryType>, MemberType> learner) {
        this(learner, 100, 1.0, new Random());
    }

    public OnlineBaggingCategorizerLearner(IncrementalLearner<? super InputOutputPair<? extends InputType, CategoryType>, MemberType> learner, int ensembleSize, double percentToSample, Random random) {
        this.setLearner(learner);
        this.setEnsembleSize(ensembleSize);
        this.setPercentToSample(percentToSample);
        this.setRandom(random);
    }

    @Override
    public VotingCategorizerEnsemble<InputType, CategoryType, MemberType> createInitialLearnedObject() {
        int size = this.getEnsembleSize();
        ArrayList<MemberType> members = new ArrayList<MemberType>(size);
        for (int i = 0; i < this.ensembleSize; ++i) {
            members.add(this.getLearner().createInitialLearnedObject());
        }
        return new VotingCategorizerEnsemble(new LinkedHashSet(), members);
    }

    @Override
    public void update(VotingCategorizerEnsemble<InputType, CategoryType, MemberType> target, InputType input, CategoryType category) {
        this.update(target, (InputOutputPair<? extends InputType, CategoryType>)DefaultInputOutputPair.create(input, category));
    }

    @Override
    public void update(VotingCategorizerEnsemble<InputType, CategoryType, MemberType> target, InputOutputPair<? extends InputType, CategoryType> data) {
        CategoryType category = data.getOutput();
        if (!target.getCategories().contains(category)) {
            target.getCategories().add(category);
        }
        PoissonDistribution.PMF poisson = new PoissonDistribution.PMF(this.getPercentToSample());
        for (Evaluator member : target.getMembers()) {
            int updateCount = ((Number)poisson.sample(this.random)).intValue();
            for (int i = 0; i < updateCount; ++i) {
                this.learner.update(member, data);
            }
        }
    }

    public IncrementalLearner<? super InputOutputPair<? extends InputType, CategoryType>, MemberType> getLearner() {
        return this.learner;
    }

    public void setLearner(IncrementalLearner<? super InputOutputPair<? extends InputType, CategoryType>, MemberType> learner) {
        this.learner = learner;
    }

    public int getEnsembleSize() {
        return this.ensembleSize;
    }

    public void setEnsembleSize(int ensembleSize) {
        ArgumentChecker.assertIsPositive((String)"ensembleSize", (int)ensembleSize);
        this.ensembleSize = ensembleSize;
    }

    public double getPercentToSample() {
        return this.percentToSample;
    }

    public void setPercentToSample(double percentToSample) {
        ArgumentChecker.assertIsPositive((String)"percentToSample", (double)percentToSample);
        this.percentToSample = percentToSample;
    }

    public Random getRandom() {
        return this.random;
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public static <InputType, CategoryType, MemberType extends Evaluator<? super InputType, ? extends CategoryType>> OnlineBaggingCategorizerLearner<InputType, CategoryType, MemberType> create(IncrementalLearner<? super InputOutputPair<? extends InputType, CategoryType>, MemberType> learner, int ensembleSize, double percentToSample, Random random) {
        return new OnlineBaggingCategorizerLearner<InputType, CategoryType, MemberType>(learner, ensembleSize, percentToSample, random);
    }
}

