/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering.initializer;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.AbstractMinDistanceFixedClusterInitializer;
import gov.sandia.cognition.math.DivergenceFunction;
import java.util.Random;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-23", changesNeeded=false, comments={"Now extends AbstractRandomized", "Cleaned up javadoc a little bit with code annotations.", "Otherwise, looks fine."})
public class GreedyClusterInitializer<ClusterType extends Cluster<DataType>, DataType>
extends AbstractMinDistanceFixedClusterInitializer<ClusterType, DataType> {
    public GreedyClusterInitializer() {
        this(null, null, new Random());
    }

    public GreedyClusterInitializer(DivergenceFunction<? super DataType, ? super DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator, Random random) {
        super(divergenceFunction, creator, random);
    }

    @Override
    public GreedyClusterInitializer<ClusterType, DataType> clone() {
        return (GreedyClusterInitializer)super.clone();
    }

    @Override
    protected int selectNextClusterIndex(double[] minDistances, boolean[] selected) {
        double maxMinDistance = Double.MAX_VALUE;
        int maxIndex = 0;
        int elementCount = minDistances.length;
        for (int i = 0; i < elementCount; ++i) {
            if (selected[i]) continue;
            double minDistance = minDistances[i];
            if (maxIndex != 0 && !(minDistance > maxMinDistance)) continue;
            maxIndex = i;
            maxMinDistance = minDistance;
        }
        if (maxMinDistance <= 0.0) {
            return -1;
        }
        return maxIndex;
    }
}

