/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering.initializer;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.AbstractMinDistanceFixedClusterInitializer;
import gov.sandia.cognition.math.DivergenceFunction;
import gov.sandia.cognition.statistics.DiscreteSamplingUtil;
import java.util.Random;

@PublicationReference(author={"David Arthur", "Sergei Vassilvitskii"}, title="k-means++: the advantages of careful seeding", year=2007, type=PublicationType.Conference, publication="Proceedings of the eighteenth annual ACM-SIAM Symposium on Discrete algorithms (SODA)", url="http://portal.acm.org/citation.cfm?id=1283383.1283494")
public class DistanceSamplingClusterInitializer<ClusterType extends Cluster<DataType>, DataType>
extends AbstractMinDistanceFixedClusterInitializer<ClusterType, DataType> {
    public DistanceSamplingClusterInitializer() {
        this(null, null, new Random());
    }

    public DistanceSamplingClusterInitializer(DivergenceFunction<? super DataType, ? super DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator, Random random) {
        super(divergenceFunction, creator, random);
    }

    @Override
    public DistanceSamplingClusterInitializer<ClusterType, DataType> clone() {
        return (DistanceSamplingClusterInitializer)super.clone();
    }

    @Override
    protected int selectNextClusterIndex(double[] minDistances, boolean[] selected) {
        int elementCount = minDistances.length;
        double[] cumulativeDistribution = new double[elementCount];
        double sum = 0.0;
        for (int i = 0; i < elementCount; ++i) {
            double minDistance = minDistances[i];
            double weight = minDistance * minDistance;
            cumulativeDistribution[i] = sum += weight;
        }
        if (sum <= 0.0) {
            return -1;
        }
        return DiscreteSamplingUtil.sampleIndexFromCumulativeProportions(this.getRandom(), cumulativeDistribution);
    }
}

