/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering.cluster;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.CentroidCluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.function.distance.DefaultDivergenceFunctionContainer;
import gov.sandia.cognition.math.DivergenceFunction;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Code generally looks fine."})
public class MedoidClusterCreator<DataType>
extends DefaultDivergenceFunctionContainer<DataType, DataType>
implements ClusterCreator<CentroidCluster<DataType>, DataType> {
    public MedoidClusterCreator() {
        this((DivergenceFunction<DataType, DataType>)null);
    }

    public MedoidClusterCreator(DivergenceFunction<? super DataType, ? super DataType> divergenceFunction) {
        super(divergenceFunction);
    }

    @Override
    public CentroidCluster<DataType> createCluster(Collection<DataType> members) {
        double minTotalDivergence = Double.POSITIVE_INFINITY;
        Object medoid = null;
        for (DataType candidate : members) {
            double totalDivergence = 0.0;
            for (DataType member : members) {
                if (candidate != member) {
                    totalDivergence += this.divergenceFunction.evaluate(candidate, member);
                }
                if (!(minTotalDivergence < totalDivergence)) continue;
                break;
            }
            if (medoid != null && !(minTotalDivergence > totalDivergence)) continue;
            minTotalDivergence = totalDivergence;
            medoid = candidate;
        }
        return new CentroidCluster<Object>(medoid, (Collection<Object>)members);
    }
}

