/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.clustering;

import gov.sandia.cognition.algorithm.MeasurablePerformanceAlgorithm;
import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.annotation.CodeReviews;
import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.learning.algorithm.AbstractAnytimeBatchLearner;
import gov.sandia.cognition.learning.algorithm.clustering.BatchClusterer;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.Cluster;
import gov.sandia.cognition.learning.algorithm.clustering.cluster.ClusterCreator;
import gov.sandia.cognition.learning.algorithm.clustering.divergence.ClusterDivergenceFunction;
import gov.sandia.cognition.learning.algorithm.clustering.initializer.FixedClusterInitializer;
import gov.sandia.cognition.util.DefaultNamedValue;
import gov.sandia.cognition.util.NamedValue;
import gov.sandia.cognition.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

@CodeReviews(reviews={@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-10-06", changesNeeded=true, comments={"The constructors for this class are not user friendly.", "I've been trying to write a test GUI for k-means for over an hour and STILL can't figure out the combination of classes to configure the constructor.", "Please make a constructor that configures the class with meaningful, user-friendly default arguments."}), @CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Changed the condition to be 'members.size() > 0' instead of 1 in createClustersFromAssignments()", "Cleaned up javadoc.", "Code generally looks fine."})})
@PublicationReferences(references={@PublicationReference(author={"Wikipedia"}, title="K-means algorithm", type=PublicationType.WebPage, year=2008, url="http://en.wikipedia.org/wiki/K-means_algorithm"), @PublicationReference(author={"Matteo Matteucci"}, title="A Tutorial on Clustering Algorithms: k-means Demo", type=PublicationType.WebPage, year=2008, url="http://home.dei.polimi.it/matteucc/Clustering/tutorial_html/AppletKM.html")})
public class KMeansClusterer<DataType, ClusterType extends Cluster<DataType>>
extends AbstractAnytimeBatchLearner<Collection<? extends DataType>, Collection<ClusterType>>
implements BatchClusterer<DataType, ClusterType>,
MeasurablePerformanceAlgorithm {
    public static final int DEFAULT_NUM_REQUESTED_CLUSTERS = 10;
    public static final int DEFAULT_MAX_ITERATIONS = 1000;
    protected int numRequestedClusters;
    protected FixedClusterInitializer<ClusterType, DataType> initializer;
    protected ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction;
    protected ClusterCreator<ClusterType, DataType> creator;
    protected ArrayList<ClusterType> clusters;
    protected int[] assignments;
    protected int[] clusterCounts;
    private int numChanged;

    public KMeansClusterer() {
        this(10, 1000, null, null, null);
    }

    public KMeansClusterer(int numRequestedClusters, int maxIterations, FixedClusterInitializer<ClusterType, DataType> initializer, ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction, ClusterCreator<ClusterType, DataType> creator) {
        super(maxIterations);
        this.setNumRequestedClusters(numRequestedClusters);
        this.setInitializer(initializer);
        this.setDivergenceFunction(divergenceFunction);
        this.setCreator(creator);
    }

    @Override
    public KMeansClusterer<DataType, ClusterType> clone() {
        KMeansClusterer result = (KMeansClusterer)super.clone();
        result.initializer = (FixedClusterInitializer)ObjectUtil.cloneSafe(this.initializer);
        result.divergenceFunction = (ClusterDivergenceFunction)ObjectUtil.cloneSafe(this.divergenceFunction);
        result.creator = (ClusterCreator)ObjectUtil.cloneSafe(this.creator);
        result.clusters = null;
        result.assignments = null;
        result.clusterCounts = null;
        return result;
    }

    @Override
    protected boolean initializeAlgorithm() {
        this.setClusters(this.initializer.initializeClusters(this.numRequestedClusters, (Collection)this.data));
        this.setClusterCounts(new int[this.getNumClusters()]);
        this.setAssignments(new int[this.getNumElements()]);
        Arrays.fill(this.assignments, -1);
        Arrays.fill(this.clusterCounts, 0);
        this.setNumChanged(0);
        return this.getNumClusters() <= this.getNumElements();
    }

    @Override
    protected boolean step() {
        int[] newAssignements = this.assignDataToClusters((Collection)this.getData());
        int nc = 0;
        for (int i = 0; i < newAssignements.length; ++i) {
            int newAssignment = newAssignements[i];
            if (!this.setAssignment(i, newAssignment)) continue;
            ++nc;
        }
        this.setNumChanged(nc);
        if (this.getNumChanged() > 0) {
            this.createClustersFromAssignments();
            return true;
        }
        return false;
    }

    @Override
    protected void cleanupAlgorithm() {
    }

    protected int[] assignDataToClusters(Collection<? extends DataType> data) {
        int i = 0;
        int[] localAssignments = new int[data.size()];
        for (DataType element : data) {
            localAssignments[i] = this.getClosestClusterIndex(element);
            ++i;
        }
        return localAssignments;
    }

    @Override
    public void setData(Collection<? extends DataType> data) {
        super.setData(data);
    }

    protected ArrayList<ArrayList<DataType>> assignDataFromIndices() {
        int numClusters = this.getNumClusters();
        ArrayList<ArrayList<DataType>> clustersMembers = new ArrayList<ArrayList<DataType>>(numClusters);
        for (int i = 0; i < numClusters; ++i) {
            int clusterSize = this.clusterCounts[i];
            clustersMembers.add(new ArrayList(clusterSize));
        }
        int index = 0;
        for (Object element : (Collection)this.data) {
            int assignment = this.assignments[index];
            clustersMembers.get(assignment).add(element);
            ++index;
        }
        return clustersMembers;
    }

    protected void createClustersFromAssignments() {
        int numClusters = this.getNumClusters();
        ArrayList<ArrayList<DataType>> clustersMembers = this.assignDataFromIndices();
        for (int i = 0; i < numClusters; ++i) {
            ArrayList<DataType> members = clustersMembers.get(i);
            Object cluster = members.size() > 0 ? (Object)this.creator.createCluster(members) : null;
            this.clusters.set(i, cluster);
        }
    }

    protected int getClosestClusterIndex(DataType element) {
        double minDistance = Double.MAX_VALUE;
        int closestClusterIndex = -1;
        for (int i = 0; i < this.getNumClusters(); ++i) {
            Cluster cluster = (Cluster)this.clusters.get(i);
            double distance = this.divergenceFunction.evaluate(cluster, element);
            if (closestClusterIndex >= 0 && !(distance < minDistance)) continue;
            minDistance = distance;
            closestClusterIndex = i;
        }
        return closestClusterIndex;
    }

    protected boolean setAssignment(int elementIndex, int newClusterIndex) {
        int oldClusterIndex = this.assignments[elementIndex];
        this.assignments[elementIndex] = newClusterIndex;
        if (oldClusterIndex >= 0) {
            int n = oldClusterIndex;
            this.clusterCounts[n] = this.clusterCounts[n] - 1;
        }
        if (newClusterIndex >= 0) {
            int n = newClusterIndex;
            this.clusterCounts[n] = this.clusterCounts[n] + 1;
        }
        return newClusterIndex != oldClusterIndex;
    }

    protected ClusterType getCluster(int index) {
        return (ClusterType)((Cluster)this.clusters.get(index));
    }

    protected int getNumClusters() {
        return this.getClusters() == null ? 0 : this.getClusters().size();
    }

    public int getNumRequestedClusters() {
        return this.numRequestedClusters;
    }

    public FixedClusterInitializer<ClusterType, DataType> getInitializer() {
        return this.initializer;
    }

    public ClusterDivergenceFunction<ClusterType, DataType> getDivergenceFunction() {
        return this.divergenceFunction;
    }

    public ClusterCreator<ClusterType, DataType> getCreator() {
        return this.creator;
    }

    public void setNumRequestedClusters(int numRequestedClusters) {
        if (numRequestedClusters < 0) {
            throw new IllegalArgumentException("The number of clusters cannot be less than zero.");
        }
        this.numRequestedClusters = numRequestedClusters;
    }

    public void setInitializer(FixedClusterInitializer<ClusterType, DataType> initializer) {
        this.initializer = initializer;
    }

    public void setDivergenceFunction(ClusterDivergenceFunction<ClusterType, DataType> divergenceFunction) {
        this.divergenceFunction = divergenceFunction;
    }

    public void setCreator(ClusterCreator<ClusterType, DataType> creator) {
        this.creator = creator;
    }

    public int getNumElements() {
        if (this.data != null) {
            return ((Collection)this.data).size();
        }
        return 0;
    }

    protected void setClusters(ArrayList<ClusterType> clusters) {
        this.clusters = clusters;
    }

    public ArrayList<ClusterType> getClusters() {
        return this.clusters;
    }

    public ArrayList<ClusterType> getResult() {
        return this.getClusters();
    }

    private void setAssignments(int[] assignments) {
        this.assignments = assignments;
    }

    protected int[] getAssignments() {
        return this.assignments;
    }

    private void setClusterCounts(int[] clusterCounts) {
        this.clusterCounts = clusterCounts;
    }

    protected int[] getClusterCounts() {
        return this.clusterCounts;
    }

    public int getNumChanged() {
        return this.numChanged;
    }

    protected void setNumChanged(int numChanged) {
        this.numChanged = numChanged;
    }

    public NamedValue<Integer> getPerformance() {
        return new DefaultNamedValue("Assignments changed", (Object)this.getNumChanged());
    }
}

