/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.baseline;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.DatasetUtil;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.ConstantEvaluator;
import gov.sandia.cognition.statistics.distribution.MapBasedPointMassDistribution;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Fixed a few typos in javadoc.", "Removed implements Serializeable, as BatchLearner already does that.", "I don't particularly like this class... I just don't think it's useful.", "However, the code looks fine."})
public class WeightedMostFrequentLearner<OutputType>
extends AbstractCloneableSerializable
implements SupervisedBatchLearner<Object, OutputType, ConstantEvaluator<OutputType>> {
    @Override
    public ConstantEvaluator<OutputType> learn(Collection<? extends InputOutputPair<? extends Object, OutputType>> data) {
        MapBasedPointMassDistribution<OutputType> weightDistribution = new MapBasedPointMassDistribution<OutputType>();
        for (InputOutputPair<Object, OutputType> example : data) {
            double weight = DatasetUtil.getWeight(example);
            OutputType output = example.getOutput();
            weightDistribution.add(output, weight);
        }
        ConstantEvaluator result = new ConstantEvaluator();
        if (weightDistribution.getTotalMass() > 0.0) {
            result.setValue(weightDistribution.getMaximumValue());
        }
        return result;
    }
}

