/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.learning.algorithm.baseline;

import gov.sandia.cognition.annotation.CodeReview;
import gov.sandia.cognition.learning.algorithm.SupervisedBatchLearner;
import gov.sandia.cognition.learning.data.InputOutputPair;
import gov.sandia.cognition.learning.function.ConstantEvaluator;
import gov.sandia.cognition.statistics.distribution.MapBasedDataHistogram;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;

@CodeReview(reviewer={"Kevin R. Dixon"}, date="2008-07-22", changesNeeded=false, comments={"Fixed a few typos in javadoc.", "Removed implements Serializeable, as BatchLearner already does that.", "I don't particularly like this class... I just don't think it's useful.", "However, the code looks fine."})
public class MostFrequentLearner<OutputType>
extends AbstractCloneableSerializable
implements SupervisedBatchLearner<Object, OutputType, ConstantEvaluator<OutputType>> {
    @Override
    public ConstantEvaluator<OutputType> learn(Collection<? extends InputOutputPair<? extends Object, OutputType>> data) {
        MapBasedDataHistogram<OutputType> counts = new MapBasedDataHistogram<OutputType>();
        for (InputOutputPair<Object, OutputType> example : data) {
            counts.add(example.getOutput());
        }
        ConstantEvaluator result = new ConstantEvaluator();
        if (counts.getTotalCount() > 0) {
            result.setValue(counts.getMaximumValue());
        }
        return result;
    }
}

