/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.sampling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.openimaj.image.Image;
import org.openimaj.math.geometry.shape.Rectangle;

public class RectangleSampler
implements Iterable<Rectangle> {
    float minx;
    float maxx;
    float miny;
    float maxy;
    float stepx;
    float stepy;
    float width;
    float height;

    public RectangleSampler(float minx, float maxx, float miny, float maxy, float stepx, float stepy, float width, float height) {
        this.setBounds(minx, maxx, miny, maxy);
        this.stepx = stepx;
        this.stepy = stepy;
        this.width = width;
        this.height = height;
    }

    public RectangleSampler(Rectangle bounds, float stepx, float stepy, float width, float height) {
        this.setBounds(bounds);
        this.stepx = stepx;
        this.stepy = stepy;
        this.width = width;
        this.height = height;
    }

    public RectangleSampler(Image<?, ?> img, float stepx, float stepy, float width, float height) {
        this.setBounds(img);
        this.stepx = stepx;
        this.stepy = stepy;
        this.width = width;
        this.height = height;
    }

    public void setBounds(float minx, float maxx, float miny, float maxy) {
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
    }

    public void setBounds(Rectangle r) {
        if (r == null) {
            return;
        }
        this.minx = r.x;
        this.maxx = r.x + r.width;
        this.miny = r.y;
        this.maxy = r.y + r.height;
    }

    public void setBounds(Image<?, ?> img) {
        if (img == null) {
            return;
        }
        this.setBounds(img.getBounds());
    }

    public List<Rectangle> allRectangles() {
        ArrayList<Rectangle> list = new ArrayList<Rectangle>();
        for (Rectangle r : this) {
            list.add(r);
        }
        return list;
    }

    @Override
    public Iterator<Rectangle> iterator() {
        return new Iterator<Rectangle>(){
            float x;
            float y;
            {
                this.x = RectangleSampler.this.minx;
                this.y = RectangleSampler.this.miny;
            }

            @Override
            public boolean hasNext() {
                return this.x + RectangleSampler.this.width <= RectangleSampler.this.maxx && this.y + RectangleSampler.this.height <= RectangleSampler.this.maxy;
            }

            @Override
            public Rectangle next() {
                if (this.y + RectangleSampler.this.height > RectangleSampler.this.maxy) {
                    throw new NoSuchElementException();
                }
                float nextX = this.x + RectangleSampler.this.stepx;
                float nextY = this.y;
                if (nextX + RectangleSampler.this.width > RectangleSampler.this.maxx) {
                    nextX = RectangleSampler.this.minx;
                    nextY += RectangleSampler.this.stepy;
                }
                Rectangle r = new Rectangle(this.x, this.y, RectangleSampler.this.width, RectangleSampler.this.height);
                this.x = nextX;
                this.y = nextY;
                return r;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal is not supported!");
            }
        };
    }

    public <I extends Image<?, I>> Iterator<I> subImageIterator(final I image) {
        return new Iterator<I>(){
            Iterator<Rectangle> inner;
            {
                this.inner = RectangleSampler.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.inner.hasNext();
            }

            @Override
            public I next() {
                Rectangle r = this.inner.next();
                return image.extractROI(r);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal is not supported!");
            }
        };
    }
}

