/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter.finance;

import com.Ostermiller.util.CSVParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.openimaj.io.CachableASCII;
import org.openimaj.ml.timeseries.processor.interpolation.LinearInterpolationProcessor;
import org.openimaj.ml.timeseries.processor.interpolation.util.TimeSpanUtils;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;

public class YahooFinanceData
implements CachableASCII {
    private static final String YAHOO_URL = "http://ichart.finance.yahoo.com/table.csv";
    private String product;
    private DateTime start;
    private DateTime end;
    private String data;
    private String[] titles;
    private Map<String, double[]> datavalues;
    private int nentries;
    private boolean loadedFromAPICall = false;

    public YahooFinanceData() {
    }

    public YahooFinanceData(String product, DateTime start, DateTime end) {
        this.product = product;
        this.start = start;
        this.end = end;
    }

    public YahooFinanceData(String product, String start, String end, String format) {
        DateTimeFormatter parser = DateTimeFormat.forPattern((String)format);
        this.start = parser.parseDateTime(start);
        this.end = parser.parseDateTime(end);
        this.product = product;
    }

    private void prepare() throws IOException {
        if (this.data == null) {
            String uri = this.buildURI(this.product, this.start, this.end);
            this.data = this.doCall(uri);
            this.loadedFromAPICall = true;
            this.readData();
        }
    }

    private void readData() throws IOException {
        StringReader reader = new StringReader(this.data);
        this.readData(reader);
    }

    private void readData(Reader in) throws IOException {
        CSVParser creader = new CSVParser(in);
        this.datavalues = new HashMap<String, double[]>();
        for (String title : this.titles = creader.getLine()) {
            this.datavalues.put(title, new double[this.nentries]);
        }
        String[] line = null;
        DateTimeFormatter parser = DateTimeFormat.forPattern((String)"YYYY-MM-dd");
        int entry = this.nentries - 1;
        while ((line = creader.getLine()) != null) {
            for (int i = 0; i < this.titles.length; ++i) {
                String title = this.titles[i];
                if (i == 0) {
                    DateTime dt = parser.parseDateTime(line[i]);
                    this.datavalues.get((Object)title)[entry] = dt.getMillis();
                    continue;
                }
                this.datavalues.get((Object)title)[entry] = Double.parseDouble(line[i]);
            }
            --entry;
        }
    }

    public String resultsString() throws IOException {
        this.prepare();
        return this.data;
    }

    public Map<String, double[]> results() throws IOException {
        this.prepare();
        return this.datavalues;
    }

    private String buildURI(String product, DateTime start, DateTime end) {
        StringBuilder uri = new StringBuilder();
        DateTime actualstart = start;
        uri.append(YAHOO_URL);
        uri.append("?s=").append(product);
        uri.append("&a=").append(actualstart.getMonthOfYear() - 1);
        uri.append("&b=").append(actualstart.getDayOfMonth());
        uri.append("&c=").append(actualstart.getYear());
        uri.append("&d=").append(end.getMonthOfYear() - 1);
        uri.append("&e=").append(end.getDayOfMonth());
        uri.append("&f=").append(end.getYear());
        uri.append("&g=d");
        return uri.toString();
    }

    private String responseToString(InputStream stream) throws IOException {
        BufferedInputStream bi = new BufferedInputStream(stream);
        StringBuilder sb = new StringBuilder();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        this.nentries = 0;
        while ((bytesRead = bi.read(buffer)) != -1) {
            String s = new String(buffer, 0, bytesRead);
            for (char b : s.toCharArray()) {
                if (b != '\n') continue;
                ++this.nentries;
            }
            sb.append(s);
        }
        --this.nentries;
        return sb.toString();
    }

    private String doCall(String uri) throws IOException {
        System.out.println("We're calling the uri");
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setCookiePolicy("compatibility");
        GetMethod getMethod = new GetMethod(uri);
        try {
            int response = httpClient.executeMethod((HttpMethod)getMethod);
            if (response != 200) {
                throw new IOException("HTTP problem, httpcode: " + response);
            }
            InputStream stream = getMethod.getResponseBodyAsStream();
            String responseText = this.responseToString(stream);
            return responseText;
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void readASCII(Scanner in) throws IOException {
        String[] inputParts = in.nextLine().split(" ");
        this.product = inputParts[0];
        this.start = new DateTime(Long.parseLong(inputParts[1]));
        this.end = new DateTime(Long.parseLong(inputParts[2]));
        this.nentries = Integer.parseInt(inputParts[3]);
        this.data = "";
        while (in.hasNextLine()) {
            String l = in.nextLine();
            if (l.length() == 0) continue;
            this.data = this.data + l + "\n";
        }
        this.readData();
    }

    public String asciiHeader() {
        return "YAHOO-FINANCE\n";
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.prepare();
        out.printf("%s %s %s %s\n", this.product, this.start.getMillis(), this.end.getMillis(), this.nentries);
        out.println(this.data);
    }

    public long[] timeperiods() throws IOException {
        this.prepare();
        double[] dates = this.datavalues.get("Date");
        long[] times = new long[dates.length];
        int i = 0;
        for (double d : dates) {
            times[i++] = (long)d;
        }
        return times;
    }

    public DoubleTimeSeries seriesByName(String name) throws IOException {
        this.prepare();
        if (!this.datavalues.containsKey(name)) {
            return null;
        }
        return new DoubleTimeSeries(this.timeperiods(), this.datavalues.get(name));
    }

    public Map<String, DoubleTimeSeries> seriesMap() throws IOException {
        this.prepare();
        HashMap<String, DoubleTimeSeries> ret = new HashMap<String, DoubleTimeSeries>();
        long[] tp = this.timeperiods();
        for (Map.Entry<String, double[]> namevalues : this.datavalues.entrySet()) {
            if (namevalues.getKey().equals("Date")) continue;
            ret.put(namevalues.getKey(), new DoubleTimeSeries(tp, namevalues.getValue()));
        }
        return ret;
    }

    public Map<String, DoubleTimeSeries> seriesMapInerp(long[] times) throws IOException {
        this.prepare();
        HashMap<String, DoubleTimeSeries> ret = new HashMap<String, DoubleTimeSeries>();
        LinearInterpolationProcessor interp = new LinearInterpolationProcessor(times);
        long[] tp = this.timeperiods();
        for (Map.Entry<String, double[]> namevalues : this.datavalues.entrySet()) {
            if (namevalues.getKey().equals("Date")) continue;
            DoubleTimeSeries dt = new DoubleTimeSeries(tp, namevalues.getValue());
            interp.process(dt);
            ret.put(namevalues.getKey(), dt);
        }
        return ret;
    }

    public Set<String> labels() {
        return this.datavalues.keySet();
    }

    public Map<String, DoubleTimeSeries> seriesMapInerp(long delta) throws IOException {
        long[] financeTimes = this.timeperiods();
        long start = financeTimes[0];
        long end = financeTimes[financeTimes.length - 1];
        long[] times = TimeSpanUtils.getTime((long)start, (long)end, (long)delta);
        return this.seriesMapInerp(times);
    }

    public String identifier() {
        DateTimeFormatter parser = DateTimeFormat.forPattern((String)"YYYY-MM-dd");
        String startDate = this.start.toString(parser);
        String endDate = this.end.toString(parser);
        return String.format("%s-%s-%s", this.product, startDate, endDate);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof YahooFinanceData)) {
            return false;
        }
        YahooFinanceData that = (YahooFinanceData)obj;
        try {
            this.prepare();
            that.prepare();
        }
        catch (IOException e) {
            return false;
        }
        return this.data.equals(that.data);
    }

    public String toString() {
        return this.data;
    }

    public boolean loadedFromAPI() {
        return this.loadedFromAPICall;
    }
}

