/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter.collection;

import com.google.gson.Gson;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;
import org.openimaj.util.list.AbstractStreamBackedList;

public class StreamJSONStatusList
extends AbstractStreamBackedList<ReadableWritableJSON> {
    protected StreamJSONStatusList(InputStream stream, int size, boolean isBinary, int headerLength, int recordLength, String charset) throws IOException {
        super(stream, size, isBinary, headerLength, recordLength, ReadableWritableJSON.class, charset);
    }

    public static StreamJSONStatusList read(InputStream stream, int nTweets) throws IOException {
        return StreamJSONStatusList.read(new BufferedInputStream(stream), nTweets);
    }

    public static StreamJSONStatusList read(InputStream stream) throws IOException {
        return StreamJSONStatusList.read(new BufferedInputStream(stream), -1);
    }

    public static StreamJSONStatusList read(InputStream stream, int nTweets, String charset) throws IOException {
        return StreamJSONStatusList.read(new BufferedInputStream(stream), nTweets, charset);
    }

    public static StreamJSONStatusList read(InputStream stream, String charset) throws IOException {
        return StreamJSONStatusList.read(new BufferedInputStream(stream), -1, charset);
    }

    public static StreamJSONStatusList read(BufferedInputStream stream, int nTweets) throws IOException {
        boolean isBinary = false;
        int size = nTweets;
        int headerLength = 0;
        int recordLength = -1;
        return new StreamJSONStatusList(stream, size, isBinary, headerLength, recordLength, "UTF-8");
    }

    public static StreamJSONStatusList read(BufferedInputStream stream, int nTweets, String charset) throws IOException {
        boolean isBinary = false;
        int size = nTweets;
        int headerLength = 0;
        int recordLength = -1;
        return new StreamJSONStatusList(stream, size, isBinary, headerLength, recordLength, charset);
    }

    public static class ReadableWritableJSON
    extends HashMap<String, Object>
    implements ReadWriteable {
        private static final long serialVersionUID = 6001988896541110142L;
        private transient Gson gson = new Gson();

        public void readASCII(Scanner in) throws IOException {
            if (in == null) {
                return;
            }
            ReadableWritableJSON inner = (ReadableWritableJSON)this.gson.fromJson(in.nextLine(), ReadableWritableJSON.class);
            for (Map.Entry entry : inner.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public String asciiHeader() {
            return "";
        }

        public void readBinary(DataInput in) throws IOException {
            ReadableWritableJSON inner = (ReadableWritableJSON)this.gson.fromJson(in.readUTF(), ReadableWritableJSON.class);
            for (Map.Entry entry : inner.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public byte[] binaryHeader() {
            return "".getBytes();
        }

        public void writeASCII(PrintWriter out) throws IOException {
            this.gson.toJson((Object)this, (Appendable)out);
        }

        public void writeBinary(DataOutput out) throws IOException {
            out.writeUTF(this.gson.toJson((Object)this));
        }
    }
}

