/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter.collection;

import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.openimaj.io.Writeable;
import org.openimaj.twitter.GeneralJSON;
import org.openimaj.twitter.USMFStatus;
import org.openimaj.twitter.collection.TwitterStatusList;
import org.openimaj.twitter.collection.TwitterStatusListUtils;

public class ConvertUSMFList
implements Writeable {
    private TwitterStatusList<? extends USMFStatus> list;
    private Class<? extends GeneralJSON> convert;

    public ConvertUSMFList(TwitterStatusList<? extends USMFStatus> list, Class<? extends GeneralJSON> convertType) {
        this.list = list;
        this.convert = convertType;
    }

    public void writeASCII(PrintWriter writer) throws IOException {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            USMFStatus k = (USMFStatus)iterator.next();
            GeneralJSON newInstance = TwitterStatusListUtils.newInstance(this.convert);
            newInstance.fromUSMF(k);
            newInstance.writeASCII(writer);
            writer.println();
        }
    }

    public String asciiHeader() {
        return this.list.asciiHeader();
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.list.writeBinary(out);
    }

    public byte[] binaryHeader() {
        return this.list.binaryHeader();
    }
}

