/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.openimaj.twitter.GeneralJSON;
import org.openimaj.twitter.GeneralJSONTwitterRawText;
import org.openimaj.twitter.USMFStatus;

public class GeneralJSONTwitter
extends GeneralJSON {
    public String s = "twitter";
    public GeneralJSONTwitter retweeted_status;
    public String retweet_count;
    public String in_reply_to_screen_name;
    public String text;
    public Map<String, List<Map<String, Object>>> entities = null;
    public Map<String, Object> user = null;
    public Map<String, Object> place = null;
    public Object geo;
    public Object coordinates = null;
    public boolean retweeted;
    public double in_reply_to_status_id;
    public double in_reply_to_user_id;
    public boolean truncated;
    public long id;
    public String created_at;
    public String source;
    public String id_str;

    @Override
    public void fillUSMF(USMFStatus status) {
        status.application = this.source;
        status.date = this.created_at;
        if (this.coordinates != null) {
            double[] coords = new double[2];
            ArrayList coordList = null;
            if (this.coordinates instanceof Map) {
                coordList = (ArrayList)((Map)this.coordinates).get("coordinates");
            }
            coords[0] = (Double)coordList.get(0);
            coords[1] = (Double)coordList.get(1);
            status.geo = coords;
        }
        if (this.place != null && this.place.containsKey("name") && this.place.containsKey("country_code")) {
            status.location = (String)this.place.get("name");
            status.country_code = (String)this.place.get("country_code");
        }
        status.id = this.id;
        status.text = this.text;
        status.service = "Twitter";
        if (this.user != null) {
            String key = "profile_image_url";
            if (this.user.containsKey(key) && this.user.get(key) != null) {
                status.user.avatar = (String)this.user.get(key);
            }
            if (this.user.containsKey(key = "description") && this.user.get(key) != null) {
                status.user.description = (String)this.user.get(key);
            }
            if (this.user.containsKey(key = "id") && this.user.get(key) != null) {
                status.user.id = (Double)this.user.get("id");
            }
            if (this.user.containsKey(key = "lang") && this.user.get(key) != null) {
                status.user.language = (String)this.user.get("lang");
            }
            if (this.user.containsKey(key = "statuses_count") && this.user.get(key) != null) {
                status.user.postings = (Double)this.user.get("statuses_count");
            }
            if (this.user.containsKey(key = "name") && this.user.get(key) != null) {
                status.user.real_name = (String)this.user.get("name");
            }
            if (this.user.containsKey(key = "screen_name") && this.user.get(key) != null) {
                status.user.name = (String)this.user.get("screen_name");
            }
            if (this.user.containsKey(key = "followers_count") && this.user.get(key) != null) {
                status.user.subscribers = (Double)this.user.get("followers_count");
            }
            if (this.user.containsKey(key = "utc_offset") && this.user.get(key) != null) {
                status.user.utc = (Double)this.user.get("utc_offset");
            }
            if (this.user.containsKey(key = "url") && this.user.get(key) != null) {
                status.user.website = (String)this.user.get("url");
            }
        }
        if (this.entities != null) {
            for (Map<String, Object> link : this.entities.get("urls")) {
                USMFStatus.Link l = new USMFStatus.Link();
                Object url = link.get("expanded_url");
                if (url == null) continue;
                l.href = (String)url;
                status.links.add(l);
            }
            for (Map<String, Object> tag : this.entities.get("hashtags")) {
                Object st = tag.get("text");
                if (st == null) continue;
                status.keywords.add((String)st);
            }
            for (Map<String, Object> user : this.entities.get("user_mentions")) {
                USMFStatus.User u = new USMFStatus.User();
                u.name = (String)user.get("screen_name");
                u.real_name = (String)user.get("name");
                u.id = (Double)user.get("id");
                status.to_users.add(u);
            }
            if (this.in_reply_to_screen_name != null) {
                status.reply_to = new USMFStatus.User();
                status.reply_to.name = this.in_reply_to_screen_name;
                status.reply_to.id = this.in_reply_to_user_id;
            }
        }
        this.fillAnalysis(status);
    }

    @Override
    public void fromUSMF(USMFStatus status) {
        this.source = status.application;
        this.created_at = status.date;
        this.geo = GeneralJSONTwitter.fillCoord(status.geo);
        this.id = status.id;
        this.text = status.text;
        if (status.reply_to != null) {
            this.in_reply_to_screen_name = status.reply_to.name;
            this.in_reply_to_user_id = status.reply_to.id;
        }
        this.user = GeneralJSONTwitter.fillUserMap(status.user);
        this.entities = GeneralJSONTwitter.fillEntities(status.links, status.keywords, status.to_users);
        status.fillAnalysis(this);
    }

    private static Map<String, Object> fillCoord(double[] geo) {
        HashMap<String, Object> coord = new HashMap<String, Object>();
        coord.put("type", "Point");
        coord.put("coordinates", Arrays.asList(new double[][]{geo}));
        return coord;
    }

    private static Map<String, List<Map<String, Object>>> fillEntities(ArrayList<USMFStatus.Link> links, ArrayList<String> keywords, ArrayList<USMFStatus.User> to_users) {
        HashMap<String, List<Map<String, Object>>> ents = new HashMap<String, List<Map<String, Object>>>();
        ents.put("urls", GeneralJSONTwitter.fillURLsList(links));
        ents.put("hashtags", GeneralJSONTwitter.fillHashtagsList(keywords));
        ents.put("user_mentions", GeneralJSONTwitter.fillMentionsList(to_users));
        return ents;
    }

    private static List<Map<String, Object>> fillMentionsList(ArrayList<USMFStatus.User> to_users) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (USMFStatus.User user : to_users) {
            ret.add(GeneralJSONTwitter.fillUserMap(user));
        }
        return ret;
    }

    private static List<Map<String, Object>> fillHashtagsList(ArrayList<String> keywords) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        for (String string : keywords) {
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("text", string);
            ret.add(item);
        }
        return ret;
    }

    private static List<Map<String, Object>> fillURLsList(ArrayList<USMFStatus.Link> links) {
        ArrayList<Map<String, Object>> urls = new ArrayList<Map<String, Object>>();
        for (USMFStatus.Link link : links) {
            urls.add(GeneralJSONTwitter.fillURL(link));
        }
        return urls;
    }

    private static Map<String, Object> fillURL(USMFStatus.Link link) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("url", link.href);
        return ret;
    }

    private static Map<String, Object> fillUserMap(USMFStatus.User user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String key = "profile_image_url";
        GeneralJSONTwitter.fillMapEntry(map, key, user.avatar);
        key = "description";
        GeneralJSONTwitter.fillMapEntry(map, key, user.description);
        key = "id";
        GeneralJSONTwitter.fillMapEntry(map, key, user.id);
        key = "lang";
        GeneralJSONTwitter.fillMapEntry(map, key, user.language);
        key = "statuses_count";
        GeneralJSONTwitter.fillMapEntry(map, key, user.postings);
        key = "name";
        GeneralJSONTwitter.fillMapEntry(map, key, user.real_name);
        key = "screen_name";
        GeneralJSONTwitter.fillMapEntry(map, key, user.name);
        key = "followers_count";
        GeneralJSONTwitter.fillMapEntry(map, key, user.subscribers);
        key = "utc_offset";
        GeneralJSONTwitter.fillMapEntry(map, key, user.utc);
        key = "url";
        GeneralJSONTwitter.fillMapEntry(map, key, user.website);
        return map;
    }

    private static void fillMapEntry(Map<String, Object> map, String key, Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    public void readASCII(Scanner in) throws IOException {
        USMFStatus status = new USMFStatus(this.getClass());
        status.readASCII(in);
        this.fromUSMF(status);
    }

    @Override
    public GeneralJSON instanceFromString(String line) {
        GeneralJSONTwitter jsonInstance = null;
        try {
            jsonInstance = (GeneralJSONTwitter)gson.fromJson(line, GeneralJSONTwitter.class);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (jsonInstance.id == 0L) {
            GeneralJSONTwitterRawText raw = new GeneralJSONTwitterRawText();
            raw.text = jsonInstance.text;
            return raw;
        }
        return jsonInstance;
    }
}

