/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.twitter;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.io.ReadWriteable;
import org.openimaj.twitter.USMFStatus;

public abstract class GeneralJSON
implements ReadWriteable {
    protected static transient Gson gson = new GsonBuilder().serializeNulls().create();
    public Map<String, Object> analysis = new HashMap<String, Object>();

    public abstract void fillUSMF(USMFStatus var1);

    public abstract void fromUSMF(USMFStatus var1);

    public void readBinary(DataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] binaryHeader() {
        return "BINARYHEADER".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String asciiHeader() {
        return "";
    }

    public void writeASCII(PrintWriter out) throws IOException {
        this.writeASCIIAnalysis(out, null, null);
    }

    public void writeASCIIAnalysis(PrintWriter outputWriter, List<String> selectiveAnalysis) {
        this.writeASCIIAnalysis(outputWriter, selectiveAnalysis, new ArrayList<String>());
    }

    public void writeASCIIAnalysis(PrintWriter outputWriter, List<String> selectiveAnalysis, List<String> selectiveStatus) {
        HashMap<String, Object> toOutput = new HashMap<String, Object>();
        if (selectiveAnalysis == null && selectiveStatus == null) {
            gson.toJson((Object)this, (Appendable)outputWriter);
            return;
        }
        HashMap analysisBit = new HashMap();
        toOutput.put("analysis", analysisBit);
        for (String analysisKey : selectiveAnalysis) {
            analysisBit.put(analysisKey, this.getAnalysis(analysisKey));
        }
        for (String status : selectiveStatus) {
            try {
                Field f = this.getClass().getField(status);
                toOutput.put(status, f.get(this));
            }
            catch (SecurityException e) {
                System.err.println("Invalid field: " + status);
            }
            catch (NoSuchFieldException e) {
                System.err.println("Invalid field: " + status);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid field: " + status);
            }
            catch (IllegalAccessException e) {
                System.err.println("Invalid field: " + status);
            }
        }
        gson.toJson(toOutput, (Appendable)outputWriter);
    }

    public <T> void addAnalysis(String annKey, T annVal) {
        if (annVal instanceof Number) {
            this.analysis.put(annKey, ((Number)annVal).doubleValue());
        } else {
            this.analysis.put(annKey, annVal);
        }
    }

    public <T> T getAnalysis(String name) {
        return (T)this.analysis.get(name);
    }

    public String analysisToJSON() {
        return gson.toJson(this.analysis, Map.class);
    }

    public void fillAnalysis(GeneralJSON other) {
        other.analysis = this.analysis;
    }

    public abstract GeneralJSON instanceFromString(String var1);
}

