/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.tools.twitter.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;

public class WordDFIDF
implements ReadWriteable,
Comparable<WordDFIDF> {
    public long Ttf;
    public long Twf;
    public long tf;
    public long wf;
    public long timeperiod;

    public WordDFIDF() {
        this.wf = 0L;
        this.tf = 0L;
        this.Twf = 0L;
        this.Ttf = 0L;
    }

    public WordDFIDF(long timeperiod, long wf, long tf, long twf, long ttf) {
        this.timeperiod = timeperiod;
        this.wf = wf;
        this.tf = tf;
        this.Twf = twf;
        this.Ttf = ttf;
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeLong(this.timeperiod);
        out.writeLong(this.wf);
        out.writeLong(this.tf);
        out.writeLong(this.Twf);
        out.writeLong(this.Ttf);
    }

    public byte[] binaryHeader() {
        return "".getBytes();
    }

    public void readBinary(DataInput in) throws IOException {
        this.timeperiod = in.readLong();
        this.wf = in.readLong();
        this.tf = in.readLong();
        this.Twf = in.readLong();
        this.Ttf = in.readLong();
    }

    public double dfidf() {
        double wf = this.wf;
        double tf = this.tf;
        double Twf = this.Twf;
        double Ttf = this.Ttf;
        if (tf == 0.0 || Ttf == 0.0) {
            return 0.0;
        }
        return wf / tf * Math.log(Ttf / Twf);
    }

    @Override
    public int compareTo(WordDFIDF other) {
        return new Long(this.timeperiod).compareTo(other.timeperiod);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WordDFIDF)) {
            return false;
        }
        WordDFIDF that = (WordDFIDF)obj;
        return that.compareTo(this) == 0;
    }

    public int hashCode() {
        return (int)(this.timeperiod ^ this.timeperiod >>> 32);
    }

    public String toString() {
        String format = "(wf=%s, tf=%s, Twf=%s, Ttf=%s, DFIDF=%.5f)";
        return String.format("(wf=%s, tf=%s, Twf=%s, Ttf=%s, DFIDF=%.5f)", this.wf, this.tf, this.Twf, this.Ttf, this.dfidf());
    }

    public void readASCII(Scanner in) throws IOException {
        this.timeperiod = in.nextLong();
        this.wf = in.nextLong();
        this.tf = in.nextLong();
        this.Twf = in.nextLong();
        this.Ttf = in.nextLong();
    }

    public String asciiHeader() {
        return "";
    }

    public void writeASCII(PrintWriter out) throws IOException {
        out.printf("%s %s %s %s %s", this.timeperiod, this.wf, this.tf, this.Twf, this.Ttf);
    }
}

