/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hadoop.tools.twitter.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.io.ReadWriteableBinary;

public class TimeperiodTweetCountWordCount
implements ReadWriteableBinary {
    public long timeperiod;
    public long wordcount;
    public long tweetcount;

    public TimeperiodTweetCountWordCount() {
    }

    public TimeperiodTweetCountWordCount(long timeperiod, long wordcount, long tweetcount) {
        this.timeperiod = timeperiod;
        this.wordcount = wordcount;
        this.tweetcount = tweetcount;
    }

    public void readBinary(DataInput in) throws IOException {
        this.timeperiod = in.readLong();
        this.wordcount = in.readLong();
        this.tweetcount = in.readLong();
    }

    public byte[] binaryHeader() {
        return "".getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeLong(this.timeperiod);
        out.writeLong(this.wordcount);
        out.writeLong(this.tweetcount);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TimeperiodTweetCountWordCount)) {
            return false;
        }
        TimeperiodTweetCountWordCount that = (TimeperiodTweetCountWordCount)other;
        return this.timeperiod == that.timeperiod && this.tweetcount == that.tweetcount && this.wordcount == that.wordcount;
    }
}

