/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.topic;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationReferences;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.collection.CollectionUtil;
import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.learning.algorithm.BatchLearner;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorInputEvaluator;
import gov.sandia.cognition.math.matrix.VectorOutputEvaluator;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrix;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.decomposition.SingularValueDecompositionMTJ;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;

@PublicationReferences(references={@PublicationReference(author={"Scott Deerwester", "Susan T. Dumais", "George W. Furnas", "Thomas K. Landauer", "Richard Harshman"}, title="Indexing by Latent Semantic Analysis", year=1990, type=PublicationType.Journal, publication="Journal of the American Society for Information Science", pages={391, 407}, url="http://citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.108.8490"), @PublicationReference(author={"Thomas K. Landauer", "Peter W. Foltz", "Darrell Laham"}, title="An Introduction to Latent Semantic Analysis", year=1998, type=PublicationType.Journal, publication="Discourse Processes", pages={259, 284}, url="http://lsa.colorado.edu/papers/dp1.LSAintro.pdf"), @PublicationReference(author={"Wikipedia"}, title="Latent semantic analysis", year=2009, type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Latent_semantic_analysis")})
public class LatentSemanticAnalysis
extends AbstractCloneableSerializable
implements BatchLearner<Collection<? extends Vectorizable>, Transform> {
    public static final int DEFAULT_REQUESTED_RANK = 10;
    protected int requestedRank;

    public LatentSemanticAnalysis() {
        this(10);
    }

    public LatentSemanticAnalysis(int requestedRank) {
        this.setRequestedRank(requestedRank);
    }

    public Transform learn(Collection<? extends Vectorizable> documents) {
        boolean filterColumns;
        int dimensionality = ((Vectorizable)CollectionUtil.getFirst(documents)).convertToVector().getDimensionality();
        DenseMatrix inputMatrix = (DenseMatrix)DenseMatrixFactoryMTJ.INSTANCE.copyColumnVectors(documents);
        SingularValueDecompositionMTJ svd = SingularValueDecompositionMTJ.create((Matrix)inputMatrix);
        Matrix singularValues = svd.getS();
        Matrix termBasis = svd.getU();
        int rank = Math.min(this.getRequestedRank(), svd.effectiveRank(0.0));
        boolean filterRows = rank < singularValues.getNumRows();
        boolean bl = filterColumns = rank < singularValues.getNumColumns();
        if (filterRows || filterColumns) {
            int newRows = Math.min(singularValues.getNumRows(), rank);
            int newCols = Math.min(singularValues.getNumColumns(), rank);
            singularValues = singularValues.getSubMatrix(0, newRows - 1, 0, newCols - 1);
        }
        if (filterRows) {
            termBasis = termBasis.getSubMatrix(0, dimensionality - 1, 0, rank - 1);
        }
        return new Transform(termBasis, singularValues);
    }

    public int getRequestedRank() {
        return this.requestedRank;
    }

    public void setRequestedRank(int requestedRank) {
        if (requestedRank <= 0) {
            throw new IllegalArgumentException("requestedRank must be positive.");
        }
        this.requestedRank = requestedRank;
    }

    public static class Transform
    extends AbstractCloneableSerializable
    implements Evaluator<Vectorizable, Vector>,
    VectorInputEvaluator<Vectorizable, Vector>,
    VectorOutputEvaluator<Vectorizable, Vector> {
        protected Matrix termBasis;
        protected Matrix singularValues;
        protected Matrix transform;

        public Transform(Matrix termBasis, Matrix singularValues) {
            this.termBasis = termBasis;
            this.singularValues = singularValues;
            this.setTransform(termBasis.times(singularValues));
        }

        public Vector evaluate(Vectorizable input) {
            return input.convertToVector().times(this.transform);
        }

        public int getInputDimensionality() {
            return this.transform.getNumRows();
        }

        public int getOutputDimensionality() {
            return this.transform.getNumColumns();
        }

        public int getRank() {
            return this.getOutputDimensionality();
        }

        public Vector getTermVector(int i) {
            return this.termBasis.getColumn(i);
        }

        public Matrix getTermBasis() {
            return this.termBasis;
        }

        protected void setTermBasis(Matrix termBasis) {
            this.termBasis = termBasis;
        }

        public Matrix getSingularValues() {
            return this.singularValues;
        }

        protected void setSingularValues(Matrix singularValues) {
            this.singularValues = singularValues;
        }

        public Matrix getTransform() {
            return this.transform;
        }

        protected void setTransform(Matrix transform) {
            this.transform = transform;
        }
    }
}

