/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector.weighter;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.text.term.vector.weighter.global.GlobalTermWeighter;
import gov.sandia.cognition.text.term.vector.weighter.local.LocalTermWeighter;
import gov.sandia.cognition.text.term.vector.weighter.normalize.TermWeightNormalizer;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import gov.sandia.cognition.util.CloneableSerializable;
import gov.sandia.cognition.util.ObjectUtil;

public class CompositeLocalGlobalTermWeighter
extends AbstractCloneableSerializable
implements Evaluator<Vector, Vector> {
    protected LocalTermWeighter localWeighter;
    protected GlobalTermWeighter globalWeighter;
    protected TermWeightNormalizer normalizer;

    public CompositeLocalGlobalTermWeighter() {
        this(null, null, null);
    }

    public CompositeLocalGlobalTermWeighter(LocalTermWeighter localWeighter, GlobalTermWeighter globalWeighter, TermWeightNormalizer normalizer) {
        this.localWeighter = localWeighter;
        this.globalWeighter = globalWeighter;
        this.normalizer = normalizer;
    }

    public CompositeLocalGlobalTermWeighter clone() {
        CompositeLocalGlobalTermWeighter clone = (CompositeLocalGlobalTermWeighter)super.clone();
        clone.localWeighter = (LocalTermWeighter)ObjectUtil.cloneSafe((CloneableSerializable)this.localWeighter);
        clone.globalWeighter = (GlobalTermWeighter)ObjectUtil.cloneSmart((Object)this.globalWeighter);
        clone.normalizer = (TermWeightNormalizer)ObjectUtil.cloneSafe((CloneableSerializable)this.normalizer);
        return clone;
    }

    public Vector evaluate(Vector document) {
        Vector weights = null;
        weights = this.localWeighter == null ? document.clone() : this.localWeighter.computeLocalWeights(document);
        Vector globalWeights = null;
        if (this.globalWeighter != null && (globalWeights = this.globalWeighter.getGlobalWeights()) != null) {
            weights.dotTimesEquals((Ring)globalWeights);
        }
        if (this.normalizer != null) {
            this.normalizer.normalizeWeights(weights, document, globalWeights);
        }
        return weights;
    }

    public LocalTermWeighter getLocalWeighter() {
        return this.localWeighter;
    }

    public void setLocalWeighter(LocalTermWeighter localWeighter) {
        this.localWeighter = localWeighter;
    }

    public GlobalTermWeighter getGlobalWeighter() {
        return this.globalWeighter;
    }

    public void setGlobalWeighter(GlobalTermWeighter globalWeighter) {
        this.globalWeighter = globalWeighter;
    }

    public TermWeightNormalizer getNormalizer() {
        return this.normalizer;
    }

    public void setNormalizer(TermWeightNormalizer normalizer) {
        this.normalizer = normalizer;
    }
}

