/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.vector;

import gov.sandia.cognition.evaluator.Evaluator;
import gov.sandia.cognition.math.matrix.DefaultVectorFactoryContainer;
import gov.sandia.cognition.math.matrix.SparseVectorFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.VectorFactory;
import gov.sandia.cognition.text.term.DefaultTermIndex;
import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.text.term.TermIndex;
import gov.sandia.cognition.text.term.Termable;

public class BagOfWordsTransform
extends DefaultVectorFactoryContainer
implements Evaluator<Iterable<? extends Termable>, Vector> {
    protected TermIndex termIndex;

    public BagOfWordsTransform() {
        this(new DefaultTermIndex());
    }

    public BagOfWordsTransform(TermIndex termIndex) {
        this(termIndex, (VectorFactory<? extends Vector>)SparseVectorFactory.getDefault());
    }

    public BagOfWordsTransform(TermIndex termIndex, VectorFactory<? extends Vector> vectorFactory) {
        this.setTermIndex(termIndex);
        this.setVectorFactory(vectorFactory);
    }

    public Vector evaluate(Iterable<? extends Termable> terms) {
        return this.convertToVector(terms);
    }

    public Vector convertToVector(Iterable<? extends Termable> terms) {
        return this.convertToVector(terms, this.getVectorFactory());
    }

    public Vector convertToVector(Iterable<? extends Termable> terms, VectorFactory<?> vectorFactory) {
        return BagOfWordsTransform.convertToVector(terms, this.getTermIndex(), vectorFactory);
    }

    public static Vector convertToVector(Iterable<? extends Termable> terms, TermIndex termIndex, VectorFactory<?> vectorFactory) {
        Vector result = vectorFactory.createVector(termIndex.getTermCount());
        for (Termable termable : terms) {
            Term term = termable.asTerm();
            int index = termIndex.getIndex(term);
            if (index < 0) continue;
            double count = result.getElement(index);
            result.setElement(index, count + 1.0);
        }
        return result;
    }

    public TermIndex getTermIndex() {
        return this.termIndex;
    }

    public void setTermIndex(TermIndex termIndex) {
        this.termIndex = termIndex;
    }
}

