/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.relation;

import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.Vectorizable;
import gov.sandia.cognition.text.relation.SimilarityFunction;
import gov.sandia.cognition.text.term.TermIndex;
import gov.sandia.cognition.text.term.relation.MatrixBasedTermSimilarityNetwork;
import gov.sandia.cognition.text.term.vector.CosineSimilarityFunction;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.util.Collection;

public class TermVectorSimilarityNetworkCreator
extends AbstractCloneableSerializable {
    public static final double DEFAULT_EFFECTIVE_ZERO = 0.0;
    protected SimilarityFunction<? super Vector, ? super Vector> similarityFunction;
    protected double effectiveZero;
    protected MatrixFactory<? extends Matrix> matrixFactory;

    public TermVectorSimilarityNetworkCreator() {
        this(CosineSimilarityFunction.getInstance());
    }

    public TermVectorSimilarityNetworkCreator(SimilarityFunction<? super Vector, ? super Vector> similarityFunction) {
        this(similarityFunction, 0.0);
    }

    public TermVectorSimilarityNetworkCreator(SimilarityFunction<? super Vector, ? super Vector> similarityFunction, double effectiveZero) {
        this(similarityFunction, effectiveZero, (MatrixFactory<? extends Matrix>)MatrixFactory.getDefault());
    }

    public TermVectorSimilarityNetworkCreator(SimilarityFunction<? super Vector, ? super Vector> similarityFunction, double effectiveZero, MatrixFactory<? extends Matrix> matrixFactory) {
        this.similarityFunction = similarityFunction;
        this.effectiveZero = effectiveZero;
        this.matrixFactory = matrixFactory;
    }

    public MatrixBasedTermSimilarityNetwork create(Collection<? extends Vectorizable> documents, TermIndex termIndex) {
        int termCount = termIndex.getTermCount();
        Matrix termByDocumentMatrix = this.getMatrixFactory().copyColumnVectors(documents);
        Matrix similiarities = this.getMatrixFactory().createMatrix(termCount, termCount);
        for (int i = 0; i < termCount; ++i) {
            Vector termIVector = termByDocumentMatrix.getRow(i);
            for (int j = i; j < termCount; ++j) {
                Vector termJVector = termByDocumentMatrix.getRow(j);
                double similarity = this.similarityFunction.evaluate((Vector)termIVector, (Vector)termJVector);
                if (!(Math.abs(similarity) > this.effectiveZero)) continue;
                similiarities.setElement(i, j, similarity);
                if (i == j) continue;
                similiarities.setElement(j, i, similarity);
            }
        }
        return new MatrixBasedTermSimilarityNetwork(termIndex, similiarities);
    }

    public SimilarityFunction<? super Vector, ? super Vector> getSimilarityFunction() {
        return this.similarityFunction;
    }

    public void setSimilarityFunction(SimilarityFunction<? super Vector, ? super Vector> similarityFunction) {
        this.similarityFunction = similarityFunction;
    }

    public double getEffectiveZero() {
        return this.effectiveZero;
    }

    public void setEffectiveZero(double effectiveZero) {
        if (effectiveZero < 0.0) {
            throw new IllegalArgumentException("effectiveZero must be non-negative");
        }
        this.effectiveZero = effectiveZero;
    }

    public MatrixFactory<? extends Matrix> getMatrixFactory() {
        return this.matrixFactory;
    }

    public void setMatrixFactory(MatrixFactory<? extends Matrix> matrixFactory) {
        this.matrixFactory = matrixFactory;
    }
}

