/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.filter;

import gov.sandia.cognition.annotation.PublicationReference;
import gov.sandia.cognition.annotation.PublicationType;
import gov.sandia.cognition.text.term.TermOccurrence;
import gov.sandia.cognition.text.term.filter.AbstractSingleTermFilter;

public class TermLengthFilter
extends AbstractSingleTermFilter {
    public static final int DEFAULT_MINIMUM_LENGTH = 3;
    @PublicationReference(author={"Wikipedia"}, title="Longest word in English", year=2009, type=PublicationType.WebPage, url="http://en.wikipedia.org/wiki/Longest_word_in_English")
    public static final int DEFAULT_MAXIMUM_LENGTH = 28;
    protected Integer minimumLength;
    protected Integer maximumLength;

    public TermLengthFilter() {
        this(3, 28);
    }

    public TermLengthFilter(Integer minimumLength, Integer maximumLength) {
        this.setMinimumLength(minimumLength);
        this.setMaximumLength(maximumLength);
    }

    @Override
    public TermOccurrence filterTerm(TermOccurrence occurrence) {
        int length = occurrence.getTerm().getName().toString().length();
        if (this.minimumLength != null && length < this.minimumLength) {
            return null;
        }
        if (this.maximumLength != null && length > this.maximumLength) {
            return null;
        }
        return occurrence;
    }

    public Integer getMinimumLength() {
        return this.minimumLength;
    }

    public void setMinimumLength(Integer minimumLength) {
        if (minimumLength != null && minimumLength < 0) {
            throw new IllegalArgumentException("minimumLength must be non-negative");
        }
        this.minimumLength = minimumLength;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(Integer maximumLength) {
        if (maximumLength != null && maximumLength <= 0) {
            throw new IllegalArgumentException("maximumLength must be non-negative");
        }
        this.maximumLength = maximumLength;
    }
}

