/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.term.filter;

import gov.sandia.cognition.text.term.Term;
import gov.sandia.cognition.text.term.Termable;
import gov.sandia.cognition.text.term.filter.StopList;
import gov.sandia.cognition.util.AbstractCloneableSerializable;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class DefaultStopList
extends AbstractCloneableSerializable
implements StopList {
    protected Set<String> words;

    public DefaultStopList() {
        this.setWords(new LinkedHashSet<String>());
    }

    public DefaultStopList(Iterable<String> words) {
        this();
        this.addAll(words);
    }

    public DefaultStopList clone() {
        DefaultStopList clone = (DefaultStopList)super.clone();
        clone.words = new LinkedHashSet<String>(this.words);
        return clone;
    }

    public void add(String word) {
        this.words.add(word.toLowerCase());
    }

    public void addAll(Iterable<String> words) {
        for (String word : words) {
            this.add(word);
        }
    }

    @Override
    public boolean contains(Termable term) {
        return this.contains(term.asTerm());
    }

    public boolean contains(Term term) {
        String text = term.getName();
        return this.contains(text);
    }

    public boolean contains(String word) {
        return this.words.contains(word.toLowerCase());
    }

    public Set<String> getWords() {
        return Collections.unmodifiableSet(this.words);
    }

    protected void setWords(Set<String> words) {
        this.words = words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAsText(File file) throws IOException {
        PrintStream out = new PrintStream(file);
        try {
            this.saveAsText(out);
        }
        finally {
            out.close();
        }
    }

    public void saveAsText(PrintStream out) throws IOException {
        for (String word : this.getWords()) {
            out.println(word);
        }
    }

    public static DefaultStopList loadFromText(File file) throws IOException {
        return DefaultStopList.loadFromText(file.toURI());
    }

    public static DefaultStopList loadFromText(URI uri) throws IOException {
        return DefaultStopList.loadFromText(uri.toURL());
    }

    public static DefaultStopList loadFromText(URL url) throws IOException {
        return DefaultStopList.loadFromText(url.openConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultStopList loadFromText(URLConnection connection) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        try {
            DefaultStopList defaultStopList = DefaultStopList.loadFromText(reader);
            return defaultStopList;
        }
        finally {
            reader.close();
        }
    }

    public static DefaultStopList loadFromText(BufferedReader reader) throws IOException {
        DefaultStopList result = new DefaultStopList();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            result.add(line);
        }
        return result;
    }
}

