/*
 * Decompiled with CFR 0.152.
 */
package gov.sandia.cognition.text.document.extractor;

import gov.sandia.cognition.text.document.Document;
import gov.sandia.cognition.text.document.extractor.AbstractDocumentExtractor;
import gov.sandia.cognition.text.document.extractor.DocumentExtractionException;
import gov.sandia.cognition.text.document.extractor.SingleDocumentExtractor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;

public abstract class AbstractSingleDocumentExtractor
extends AbstractDocumentExtractor
implements SingleDocumentExtractor {
    public List<? extends Document> extractAll(File file) throws DocumentExtractionException, IOException {
        return Collections.singletonList(this.extractDocument(file));
    }

    public List<? extends Document> extractAll(URI uri) throws DocumentExtractionException, IOException {
        return Collections.singletonList(this.extractDocument(uri));
    }

    public List<? extends Document> extractAll(URLConnection connection) throws DocumentExtractionException, IOException {
        return Collections.singletonList(this.extractDocument(connection));
    }

    @Override
    public Document extractDocument(File file) throws DocumentExtractionException, IOException {
        return this.extractDocument(file.toURI());
    }

    @Override
    public Document extractDocument(URI uri) throws DocumentExtractionException, IOException {
        return this.extractDocument(uri.toURL().openConnection());
    }
}

