/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.hardware.kinect;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bridj.Pointer;
import org.openimaj.hardware.kinect.KinectStream;
import org.openimaj.hardware.kinect.KinectVideoStreamCallback;
import org.openimaj.hardware.kinect.freenect.libfreenectLibrary;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;

class RGBVideoCallback
extends KinectVideoStreamCallback<MBFImage> {
    public RGBVideoCallback(KinectStream<MBFImage> stream) {
        super(stream);
        Pointer<libfreenectLibrary.freenect_device> device = stream.controller.device;
        libfreenectLibrary.freenect_set_video_mode_proxy(device, libfreenectLibrary.freenect_resolution.FREENECT_RESOLUTION_MEDIUM, libfreenectLibrary.freenect_video_format.FREENECT_VIDEO_RGB);
        this.buffer = ByteBuffer.allocateDirect(libfreenectLibrary.freenect_get_video_buffer_size(device));
        libfreenectLibrary.freenect_set_video_buffer(device, Pointer.pointerToBuffer((Buffer)this.buffer));
        this.nextFrame = new MBFImage(stream.width, stream.height, ColourSpace.RGB);
        libfreenectLibrary.freenect_set_video_callback(device, (Pointer<libfreenectLibrary.freenect_video_cb>)this.toPointer());
        libfreenectLibrary.freenect_start_video(device);
    }

    @Override
    public void setImage() {
        ByteBuffer buf = this.buffer.duplicate();
        int width = this.stream.width;
        int height = this.stream.height;
        float[][] r = ((FImage)((MBFImage)this.nextFrame).bands.get((int)0)).pixels;
        float[][] g = ((FImage)((MBFImage)this.nextFrame).bands.get((int)1)).pixels;
        float[][] b = ((FImage)((MBFImage)this.nextFrame).bands.get((int)2)).pixels;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int red = buf.get() & 0xFF;
                int green = buf.get() & 0xFF;
                int blue = buf.get() & 0xFF;
                r[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[red];
                g[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[green];
                b[y][x] = ImageUtilities.BYTE_TO_FLOAT_LUT[blue];
            }
        }
    }

    @Override
    public void stop() {
        libfreenectLibrary.freenect_stop_video(this.stream.controller.device);
    }
}

