/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.params.ClientParamBean;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    public static final String PROP_SO_TIMEOUT = "socketTimeout";
    public static final String PROP_CONNECTION_TIMEOUT = "connTimeout";
    public static final String PROP_MAX_CONNECTIONS_PER_HOST = "maxConnectionsPerHost";
    public static final String PROP_MAX_CONNECTIONS = "maxConnections";
    public static final String PROP_USE_RETRY = "retry";
    public static final String PROP_ALLOW_COMPRESSION = "allowCompression";
    public static final String PROP_FOLLOW_REDIRECTS = "followRedirects";
    public static final String PROP_BASIC_AUTH_USER = "httpBasicAuthUser";
    public static final String PROP_BASIC_AUTH_PASS = "httpBasicAuthPassword";
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    static final DefaultHttpRequestRetryHandler NO_RETRY = new DefaultHttpRequestRetryHandler(0, false);
    private static HttpClientConfigurer configurer = new HttpClientConfigurer();

    private HttpClientUtil() {
    }

    public static void setConfigurer(HttpClientConfigurer newConfigurer) {
        configurer = newConfigurer;
    }

    public static HttpClient createClient(SolrParams params) {
        ModifiableSolrParams config = new ModifiableSolrParams(params);
        logger.info("Creating new http client, config:" + config);
        SystemDefaultHttpClient httpClient = new SystemDefaultHttpClient();
        HttpClientUtil.configureClient((DefaultHttpClient)httpClient, config);
        return httpClient;
    }

    public static void configureClient(DefaultHttpClient httpClient, SolrParams config) {
        configurer.configure(httpClient, config);
    }

    public static void setAllowCompression(DefaultHttpClient httpClient, boolean allowCompression) {
        httpClient.removeRequestInterceptorByClass(UseCompressionRequestInterceptor.class);
        httpClient.removeResponseInterceptorByClass(UseCompressionResponseInterceptor.class);
        if (allowCompression) {
            httpClient.addRequestInterceptor((HttpRequestInterceptor)new UseCompressionRequestInterceptor());
            httpClient.addResponseInterceptor((HttpResponseInterceptor)new UseCompressionResponseInterceptor());
        }
    }

    public static void setBasicAuth(DefaultHttpClient httpClient, String basicAuthUser, String basicAuthPass) {
        if (basicAuthUser != null && basicAuthPass != null) {
            httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuthUser, basicAuthPass));
        } else {
            httpClient.getCredentialsProvider().clear();
        }
    }

    public static void setMaxConnectionsPerHost(HttpClient httpClient, int max) {
        if (httpClient.getConnectionManager() instanceof ThreadSafeClientConnManager) {
            ThreadSafeClientConnManager mgr = (ThreadSafeClientConnManager)httpClient.getConnectionManager();
            mgr.setDefaultMaxPerRoute(max);
        } else if (httpClient.getConnectionManager() instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager mgr = (PoolingClientConnectionManager)httpClient.getConnectionManager();
            mgr.setDefaultMaxPerRoute(max);
        }
    }

    public static void setMaxConnections(HttpClient httpClient, int max) {
        if (httpClient.getConnectionManager() instanceof ThreadSafeClientConnManager) {
            ThreadSafeClientConnManager mgr = (ThreadSafeClientConnManager)httpClient.getConnectionManager();
            mgr.setMaxTotal(max);
        } else if (httpClient.getConnectionManager() instanceof PoolingClientConnectionManager) {
            PoolingClientConnectionManager mgr = (PoolingClientConnectionManager)httpClient.getConnectionManager();
            mgr.setMaxTotal(max);
        }
    }

    public static void setSoTimeout(HttpClient httpClient, int timeout) {
        HttpConnectionParams.setSoTimeout((HttpParams)httpClient.getParams(), (int)timeout);
    }

    public static void setUseRetry(DefaultHttpClient httpClient, boolean useRetry) {
        if (!useRetry) {
            httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)NO_RETRY);
        } else {
            httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler());
        }
    }

    public static void setConnectionTimeout(HttpClient httpClient, int timeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClient.getParams(), (int)timeout);
    }

    public static void setFollowRedirects(HttpClient httpClient, boolean followRedirects) {
        new ClientParamBean(httpClient.getParams()).setHandleRedirects(followRedirects);
    }

    private static class DeflateDecompressingEntity
    extends GzipDecompressingEntity {
        public DeflateDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        @Override
        public InputStream getContent() throws IOException, IllegalStateException {
            return new InflaterInputStream(this.wrappedEntity.getContent());
        }
    }

    private static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity entity) {
            super(entity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return new GZIPInputStream(this.wrappedEntity.getContent());
        }

        public long getContentLength() {
            return -1L;
        }
    }

    private static class UseCompressionResponseInterceptor
    implements HttpResponseInterceptor {
        private UseCompressionResponseInterceptor() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpEntity entity = response.getEntity();
            Header ceheader = entity.getContentEncoding();
            if (ceheader != null) {
                HeaderElement[] codecs = ceheader.getElements();
                for (int i = 0; i < codecs.length; ++i) {
                    if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                    if (!codecs[i].getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    private static class UseCompressionRequestInterceptor
    implements HttpRequestInterceptor {
        private UseCompressionRequestInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (!request.containsHeader("Accept-Encoding")) {
                request.addHeader("Accept-Encoding", "gzip, deflate");
            }
        }
    }
}

