/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template.extension;

import info.bliki.wiki.model.IContext;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import info.bliki.wiki.template.extension.AttributeList;
import info.bliki.wiki.template.extension.AttributeRenderer;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DollarContext
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new DollarContext();

    @Override
    public String parseFunction(List<String> list, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) throws IOException {
        if (model instanceof IContext) {
            String attribute;
            IContext context = (IContext)((Object)model);
            if (list.size() > 0 && (attribute = DollarContext.parseTrim(list.get(0), model)).length() > 0) {
                Object value;
                String formatString = null;
                String separatorString = null;
                String nullvalueString = null;
                if (list.size() > 1) {
                    formatString = DollarContext.parseTrim(list.get(1), model);
                }
                if (list.size() > 2 && (separatorString = DollarContext.parseTrim(list.get(2), model)).length() > 1) {
                    int begin = 0;
                    int end = separatorString.length();
                    if (separatorString.charAt(0) == '\'') {
                        begin = 1;
                        if (separatorString.charAt(end - 1) == '\'') {
                            --end;
                        } else {
                            begin = 0;
                        }
                    }
                    separatorString = separatorString.substring(begin, end);
                }
                if (list.size() > 3) {
                    nullvalueString = DollarContext.parseTrim(list.get(3), model);
                }
                if ((value = context.getAttribute(attribute)) != null) {
                    if (value instanceof AttributeList && ((AttributeList)value).size() > 0) {
                        AttributeList attrList = (AttributeList)value;
                        StringBuilder builder = new StringBuilder(attrList.size() * 16);
                        builder.append(this.toString(context, attrList.get(0), formatString, nullvalueString));
                        for (int i = 1; i < attrList.size(); ++i) {
                            if (separatorString != null) {
                                builder.append(separatorString);
                            }
                            builder.append(this.toString(context, attrList.get(i), formatString, nullvalueString));
                        }
                        return builder.toString();
                    }
                    StringBuilder builder = new StringBuilder();
                    builder.append(this.toString(context, value, formatString, nullvalueString));
                    return builder.toString();
                }
            }
        }
        return null;
    }

    private String toString(IContext context, Object value, String formatString, String nullvalueString) {
        AttributeRenderer renderer;
        if (value == null) {
            renderer = context.getAttributeRenderer(String.class);
            value = nullvalueString;
        } else {
            renderer = context.getAttributeRenderer(value.getClass());
        }
        if (renderer != null) {
            return renderer.toString(value, formatString);
        }
        return value.toString();
    }
}

