/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptorResolver;

public class IdRefValidator
implements TypeValidator {
    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            String err = "The object associated with IDREF \"" + object + "\" is null!";
            throw new ValidationException(err);
        }
        String id = null;
        try {
            XMLClassDescriptorResolver classDescriptorResolver = context.getClassDescriptorResolver();
            ClassDescriptor classDescriptor = classDescriptorResolver.resolve(object.getClass());
            FieldDescriptor fieldDescriptor = classDescriptor.getIdentity();
            FieldHandler fieldHandler = fieldDescriptor.getHandler();
            id = (String)fieldHandler.getValue(object);
        }
        catch (Exception e) {
            String err = "The object associated with IDREF \"" + object + "\" of type " + object.getClass() + " has no ID!";
            throw new ValidationException(err);
        }
        if (id == null) {
            String err = "The object associated with IDREF \"" + object + "\" has no ID!";
            throw new ValidationException(err);
        }
        context.checkIdRef(id);
    }
}

